/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.dbutils.AbstractQueryRunner;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class AsyncQueryRunner
extends AbstractQueryRunner {
    private final ExecutorService executorService;
    private final QueryRunner queryRunner;

    @Deprecated
    public AsyncQueryRunner(boolean pmdKnownBroken, ExecutorService executorService) {
        this(null, pmdKnownBroken, executorService);
    }

    @Deprecated
    public AsyncQueryRunner(DataSource ds, boolean pmdKnownBroken, ExecutorService executorService) {
        super(ds, pmdKnownBroken);
        this.executorService = executorService;
        this.queryRunner = new QueryRunner(ds, pmdKnownBroken);
    }

    @Deprecated
    public AsyncQueryRunner(DataSource ds, ExecutorService executorService) {
        this(ds, false, executorService);
    }

    public AsyncQueryRunner(ExecutorService executorService) {
        this(null, false, executorService);
    }

    public AsyncQueryRunner(ExecutorService executorService, QueryRunner queryRunner) {
        this.executorService = executorService;
        this.queryRunner = queryRunner;
    }

    public Future<int[]> batch(Connection conn, String sql, Object[][] params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.batch(conn, sql, params));
    }

    public Future<int[]> batch(String sql, Object[][] params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.batch(sql, params));
    }

    public <T> Future<T> insert(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.insert(conn, sql, rsh));
    }

    public <T> Future<T> insert(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.insert(conn, sql, rsh, params));
    }

    public <T> Future<T> insert(String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.insert(sql, rsh));
    }

    public <T> Future<T> insert(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.insert(sql, rsh, params));
    }

    public <T> Future<T> insertBatch(Connection conn, String sql, ResultSetHandler<T> rsh, Object[][] params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.insertBatch(conn, sql, rsh, params));
    }

    public <T> Future<T> insertBatch(String sql, ResultSetHandler<T> rsh, Object[][] params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.insertBatch(sql, rsh, params));
    }

    public <T> Future<T> query(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.query(conn, sql, rsh));
    }

    public <T> Future<T> query(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.query(conn, sql, rsh, params));
    }

    public <T> Future<T> query(String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.query(sql, rsh));
    }

    public <T> Future<T> query(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.query(sql, rsh, params));
    }

    public Future<Integer> update(Connection conn, String sql) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.update(conn, sql));
    }

    public Future<Integer> update(Connection conn, String sql, Object param) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.update(conn, sql, param));
    }

    public Future<Integer> update(Connection conn, String sql, Object ... params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.update(conn, sql, params));
    }

    public Future<Integer> update(String sql) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.update(sql));
    }

    public Future<Integer> update(String sql, Object param) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.update(sql, param));
    }

    public Future<Integer> update(String sql, Object ... params) throws SQLException {
        return this.executorService.submit(() -> this.queryRunner.update(sql, params));
    }

    @Deprecated
    protected class UpdateCallableStatement
    implements Callable<Integer> {
        private final String sql;
        private final Object[] params;
        private final Connection conn;
        private final boolean closeConn;
        private final PreparedStatement ps;

        public UpdateCallableStatement(Connection conn, boolean closeConn, PreparedStatement ps, String sql, Object ... params) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
        }

        @Override
        public Integer call() throws SQLException {
            int rows = 0;
            try {
                rows = this.ps.executeUpdate();
            }
            catch (SQLException e) {
                AsyncQueryRunner.this.rethrow(e, this.sql, this.params);
            }
            finally {
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return rows;
        }
    }

    protected class QueryCallableStatement<T>
    implements Callable<T> {
        private final String sql;
        private final Object[] params;
        private final Connection conn;
        private final boolean closeConn;
        private final PreparedStatement ps;
        private final ResultSetHandler<T> rsh;

        public QueryCallableStatement(Connection conn, boolean closeConn, PreparedStatement ps, ResultSetHandler<T> rsh, String sql, Object ... params) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
            this.rsh = rsh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws SQLException {
            ResultSet resultSet = null;
            T ret = null;
            try {
                resultSet = AsyncQueryRunner.this.wrap(this.ps.executeQuery());
                ret = this.rsh.handle(resultSet);
            }
            catch (SQLException e) {
                AsyncQueryRunner.this.rethrow(e, this.sql, this.params);
            }
            finally {
                try {
                    AsyncQueryRunner.this.close(resultSet);
                }
                finally {
                    AsyncQueryRunner.this.close(this.ps);
                    if (this.closeConn) {
                        AsyncQueryRunner.this.close(this.conn);
                    }
                }
            }
            return ret;
        }
    }

    @Deprecated
    protected class BatchCallableStatement
    implements Callable<int[]> {
        private final String sql;
        private final Object[][] params;
        private final Connection conn;
        private final boolean closeConn;
        private final PreparedStatement ps;

        public BatchCallableStatement(String sql, Object[][] params, Connection conn, boolean closeConn, PreparedStatement ps) {
            this.sql = sql;
            this.params = (Object[][])params.clone();
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
        }

        @Override
        public int[] call() throws SQLException {
            int[] ret = null;
            try {
                ret = this.ps.executeBatch();
            }
            catch (SQLException e) {
                AsyncQueryRunner.this.rethrow(e, this.sql, (Object[])this.params);
            }
            finally {
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return ret;
        }
    }
}

