/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Map;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.TestBean;
import org.apache.commons.dbutils.handlers.BeanMapHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BeanMapHandlerTest {
    private BeanMapHandler<Long, TestBean> bmh;
    private Map<Long, TestBean> res;
    @Mock
    private ResultSet rs;
    @Mock
    private ResultSetMetaData rsmd;
    @Mock
    private RowProcessor rp;

    private void handle() throws Exception {
        this.res = this.bmh.handle(this.rs);
        Assert.assertNotNull((Object)this.res.get(23L));
    }

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.rs.next()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.rs.getObject(1)).thenReturn((Object)23L);
        Mockito.when((Object)this.rs.getObject(2)).thenReturn((Object)23L);
        Mockito.when((Object)this.rs.getObject("id")).thenReturn((Object)23L);
        Mockito.when((Object)this.rs.getMetaData()).thenReturn((Object)this.rsmd);
        Mockito.when((Object)((TestBean)this.rp.toBean(this.rs, TestBean.class))).thenReturn((Object)new TestBean());
    }

    @Test
    public void testBeanMapHandlerClassOfV() throws Exception {
        this.bmh = new BeanMapHandler(TestBean.class);
        this.handle();
    }

    @Test
    public void testBeanMapHandlerClassOfVInt() throws Exception {
        this.bmh = new BeanMapHandler(TestBean.class, 2);
        this.handle();
    }

    @Test
    public void testBeanMapHandlerClassOfVRowProcessor() throws Exception {
        this.bmh = new BeanMapHandler(TestBean.class, this.rp);
        this.handle();
    }

    @Test
    public void testBeanMapHandlerClassOfVString() throws Exception {
        this.bmh = new BeanMapHandler(TestBean.class, "id");
        this.handle();
    }

    @Test
    public void testEmptyResultSet() throws Exception {
        Mockito.when((Object)this.rs.next()).thenReturn((Object)Boolean.FALSE);
        this.bmh = new BeanMapHandler(TestBean.class);
        this.res = this.bmh.handle(this.rs);
        Assert.assertNull((Object)this.res.get(23L));
    }
}

