/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WhileTest
extends JexlTestCase {
    public WhileTest() {
        super("WhileTest");
    }

    @Test
    public void testSimpleWhileFalse() throws Exception {
        JexlScript e = this.JEXL.createScript("while (false) ;");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertNull((Object)o);
    }

    @Test
    public void testWhileExecutesExpressionWhenLooping() throws Exception {
        JexlScript e = this.JEXL.createScript("while (x < 10) x = x + 1;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)1);
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    public void testWhileWithBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("while (x < 10) { x = x + 1; y = y * 2; }");
        MapContext jc = new MapContext();
        jc.set("x", (Object)1);
        jc.set("y", (Object)1);
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)512, (Object)o);
        Assertions.assertEquals((Object)10, (Object)jc.get("x"), (String)"x is wrong");
        Assertions.assertEquals((Object)512, (Object)jc.get("y"), (String)"y is wrong");
    }
}

