/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.examples;

import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.examples.AbstractOutput;
import org.junit.jupiter.api.Test;

public class MethodPropertyTest {
    public static void example(AbstractOutput out) throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Foo foo = new Foo();
        Integer number = 10;
        jc.set("foo", (Object)foo);
        jc.set("number", (Object)number);
        JexlExpression e = jexl.createExpression("foo.getFoo()");
        Object o = e.evaluate((JexlContext)jc);
        out.print("value returned by the method getFoo() is : ", o, foo.getFoo());
        e = jexl.createExpression("foo.convert(1)");
        o = e.evaluate((JexlContext)jc);
        out.print("value of " + e.getParsedText() + " is : ", o, foo.convert(1L));
        e = jexl.createExpression("foo.convert(1+7)");
        o = e.evaluate((JexlContext)jc);
        out.print("value of " + e.getParsedText() + " is : ", o, foo.convert(8L));
        e = jexl.createExpression("foo.convert(1+number)");
        o = e.evaluate((JexlContext)jc);
        out.print("value of " + e.getParsedText() + " is : ", o, foo.convert(1 + number));
        e = jexl.createExpression("foo.bar");
        o = e.evaluate((JexlContext)jc);
        out.print("value returned for the property 'bar' is : ", o, foo.get("bar"));
    }

    public static void main(String[] args) throws Exception {
        MethodPropertyTest.example(AbstractOutput.SYSTEM);
    }

    @Test
    public void testExample() throws Exception {
        MethodPropertyTest.example(AbstractOutput.JUNIT);
    }

    public static class Foo {
        public String convert(long i) {
            return "The value is : " + i;
        }

        public String get(String arg) {
            return "This is the property " + arg;
        }

        public String getFoo() {
            return "This is from getFoo()";
        }
    }
}

