/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.SampleValue;
import org.yardstickframework.BenchmarkConfiguration;

public class IgnitePutGetTxBatchBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private IgniteTransactions txs;
    private Callable<Void> clo;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.txs = this.ignite().transactions();
        this.clo = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IgniteCache cache = IgnitePutGetTxBatchBenchmark.this.cacheForOperation();
                TreeSet<Integer> keys = new TreeSet<Integer>();
                while (keys.size() < IgnitePutGetTxBatchBenchmark.this.args.batch()) {
                    keys.add(IgniteAbstractBenchmark.nextRandom(IgnitePutGetTxBatchBenchmark.this.args.range()));
                }
                Map vals = cache.getAll(keys);
                TreeMap<Integer, SampleValue> updates = new TreeMap<Integer, SampleValue>();
                for (Integer key : keys) {
                    Object val = vals.get(key);
                    if (val != null) {
                        key = IgniteAbstractBenchmark.nextRandom(IgnitePutGetTxBatchBenchmark.this.args.range());
                    }
                    updates.put(key, new SampleValue(key));
                }
                cache.putAll(updates);
                return null;
            }
        };
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        IgniteBenchmarkUtils.doInTransaction(this.txs, this.args.txConcurrency(), this.args.txIsolation(), this.clo);
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("tx");
    }
}

