/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.encryption;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.encryption.CacheGroupEncryptionKeys;
import org.apache.ignite.internal.managers.encryption.ChangeCacheEncryptionRequest;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureCancelledException;

class GroupKeyChangeProcess {
    private final GridKernalContext ctx;
    private final DistributedProcess<ChangeCacheEncryptionRequest, GridEncryptionManager.EmptyResult> prepareGKChangeProc;
    private final DistributedProcess<ChangeCacheEncryptionRequest, GridEncryptionManager.EmptyResult> performGKChangeProc;
    private final CacheGroupEncryptionKeys keys;
    private volatile GroupKeyChangeFuture fut;
    private volatile ChangeCacheEncryptionRequest req;

    GroupKeyChangeProcess(GridKernalContext ctx, CacheGroupEncryptionKeys keys) {
        this.ctx = ctx;
        this.keys = keys;
        this.prepareGKChangeProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.CACHE_GROUP_KEY_CHANGE_PREPARE, this::prepare, this::finishPrepare);
        this.performGKChangeProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.CACHE_GROUP_KEY_CHANGE_FINISH, this::perform, this::finishPerform);
    }

    public boolean inProgress() {
        return this.req != null;
    }

    public void cancel(String msg) {
        GroupKeyChangeFuture keyChangeFut = this.fut;
        if (keyChangeFut != null && !keyChangeFut.isDone()) {
            keyChangeFut.onDone(new IgniteFutureCancelledException(msg));
        }
    }

    public IgniteFuture<Void> start(Collection<String> cacheOrGrpNames) {
        if (this.ctx.clientNode()) {
            throw new UnsupportedOperationException("Client nodes can not perform this operation.");
        }
        if (!this.ctx.state().clusterState().state().active()) {
            throw new IgniteException("Operation was rejected. The cluster is inactive.");
        }
        GroupKeyChangeFuture fut0 = this.fut;
        if (fut0 != null && !fut0.isDone()) {
            return new IgniteFinishedFutureImpl<Void>(new IgniteException("Cache group key change was rejected. The previous change was not completed."));
        }
        int[] grpIds = new int[cacheOrGrpNames.size()];
        byte[] keyIds = new byte[grpIds.length];
        int n = 0;
        for (String cacheOrGrpName : cacheOrGrpNames) {
            CacheGroupDescriptor grpDesc = this.ctx.cache().cacheGroupDescriptor(CU.cacheId(cacheOrGrpName));
            if (grpDesc == null) {
                DynamicCacheDescriptor cacheDesc = this.ctx.cache().cacheDescriptor(cacheOrGrpName);
                if (cacheDesc == null) {
                    throw new IgniteException("Cache group key change was rejected. Cache or group \"" + cacheOrGrpName + "\" doesn't exists");
                }
                int grpId = cacheDesc.groupId();
                grpDesc = this.ctx.cache().cacheGroupDescriptor(grpId);
                if (grpDesc.sharedGroup()) {
                    throw new IgniteException("Cache group key change was rejected. Cache or group \"" + cacheOrGrpName + "\" is a part of group \"" + grpDesc.groupName() + "\". Provide group name instead of cache name for shared groups.");
                }
            }
            if (!grpDesc.config().isEncryptionEnabled()) {
                throw new IgniteException("Cache group key change was rejected. Cache or group \"" + cacheOrGrpName + "\" is not encrypted.");
            }
            if (this.ctx.encryption().reencryptionInProgress(grpDesc.groupId())) {
                throw new IgniteException("Cache group key change was rejected. Cache group reencryption is in progress [grp=" + cacheOrGrpName + "]");
            }
            grpIds[n] = grpDesc.groupId();
            keyIds[n] = (byte)(this.ctx.encryption().getActiveKey(grpDesc.groupId()).unsignedId() + 1);
            ++n;
        }
        T2<Collection<byte[]>, byte[]> keysAndDigest = this.ctx.encryption().createKeys(grpIds.length);
        ChangeCacheEncryptionRequest req = new ChangeCacheEncryptionRequest(grpIds, (byte[][])((Collection)keysAndDigest.get1()).toArray((T[])new byte[grpIds.length][]), keyIds, (byte[])keysAndDigest.get2());
        this.fut = new GroupKeyChangeFuture(req);
        this.prepareGKChangeProc.start(req.requestId(), req);
        return new IgniteFutureImpl<Void>(this.fut);
    }

    private IgniteInternalFuture<GridEncryptionManager.EmptyResult> prepare(ChangeCacheEncryptionRequest req) {
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<GridEncryptionManager.EmptyResult>();
        }
        if (this.inProgress()) {
            return new GridFinishedFuture<GridEncryptionManager.EmptyResult>(new IgniteException("Cache group key change was rejected. The previous change was not completed."));
        }
        if (this.ctx.cache().context().snapshotMgr().isSnapshotCreating() || this.ctx.cache().context().snapshotMgr().isRestoring()) {
            return new GridFinishedFuture<GridEncryptionManager.EmptyResult>(new IgniteException("Cache group key change was rejected. Snapshot operation is in progress."));
        }
        this.req = req;
        try {
            for (int i = 0; i < req.groupIds().length; ++i) {
                int grpId = req.groupIds()[i];
                int keyId = req.keyIds()[i] & 0xFF;
                if (this.ctx.encryption().reencryptionInProgress(grpId)) {
                    return new GridFinishedFuture<GridEncryptionManager.EmptyResult>(new IgniteException("Cache group key change was rejected. Cache group reencryption is in progress [grpId=" + grpId + "]"));
                }
                List<Integer> keyIds = this.ctx.encryption().groupKeyIds(grpId);
                if (keyIds == null) {
                    return new GridFinishedFuture<GridEncryptionManager.EmptyResult>(new IgniteException("Cache group key change was rejected.Encrypted cache group not found [grpId=" + grpId + "]"));
                }
                GroupKey currKey = this.ctx.encryption().getActiveKey(grpId);
                for (int locKeyId : keyIds) {
                    Long walSegment;
                    if (locKeyId != keyId || (walSegment = this.keys.reservedSegment(grpId, keyId)) == null && currKey.id() != (byte)keyId) continue;
                    return new GridFinishedFuture<GridEncryptionManager.EmptyResult>(new IgniteException("Cache group key change was rejected. Cannot add new key identifier, it's already present. There existing WAL segments that encrypted with this key [grpId=" + grpId + ", newId=" + keyId + ", currId=" + currKey.unsignedId() + ", walSegment=" + walSegment + "]."));
                }
            }
            return this.ctx.encryption().withMasterKeyChangeReadLock(() -> {
                if (!Arrays.equals(this.ctx.config().getEncryptionSpi().masterKeyDigest(), req.masterKeyDigest())) {
                    return new GridFinishedFuture(new IgniteException("Cache group key change was rejected. Master key has been changed."));
                }
                for (int i = 0; i < req.groupIds().length; ++i) {
                    GroupKeyEncrypted grpKey = new GroupKeyEncrypted(req.keyIds()[i] & 0xFF, req.keys()[i]);
                    this.ctx.encryption().addGroupKey(req.groupIds()[i], grpKey);
                }
                return new GridFinishedFuture<GridEncryptionManager.EmptyResult>(new GridEncryptionManager.EmptyResult());
            });
        }
        catch (Exception e) {
            return new GridFinishedFuture<GridEncryptionManager.EmptyResult>(new IgniteException("Cache group key change was rejected [nodeId=" + this.ctx.localNodeId() + "]", e));
        }
    }

    private void finishPrepare(UUID id, Map<UUID, GridEncryptionManager.EmptyResult> res, Map<UUID, Throwable> err) {
        if (!err.isEmpty()) {
            if (this.req != null && this.req.requestId().equals(id)) {
                this.req = null;
            }
            this.completeFuture(id, err, this.fut);
        } else if (U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.performGKChangeProc.start(id, this.req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<GridEncryptionManager.EmptyResult> perform(ChangeCacheEncryptionRequest req) {
        if (this.req == null || !this.req.equals(req)) {
            return new GridFinishedFuture<GridEncryptionManager.EmptyResult>(new IgniteException("Unknown cache group key change was rejected."));
        }
        try {
            if (!this.ctx.state().clusterState().state().active()) {
                throw new IgniteException("Cache group key change was rejected. The cluster is inactive.");
            }
            if (!this.ctx.clientNode()) {
                this.ctx.encryption().changeCacheGroupKeyLocal(req.groupIds(), req.keyIds(), req.keys());
            }
        }
        catch (Exception e) {
            GridFinishedFuture<GridEncryptionManager.EmptyResult> gridFinishedFuture = new GridFinishedFuture<GridEncryptionManager.EmptyResult>(e);
            return gridFinishedFuture;
        }
        finally {
            this.req = null;
        }
        return new GridFinishedFuture<GridEncryptionManager.EmptyResult>(new GridEncryptionManager.EmptyResult());
    }

    private void finishPerform(UUID id, Map<UUID, GridEncryptionManager.EmptyResult> res, Map<UUID, Throwable> err) {
        this.completeFuture(id, err, this.fut);
    }

    private boolean completeFuture(UUID reqId, Map<UUID, Throwable> err, GroupKeyChangeFuture fut) {
        boolean isInitiator;
        boolean bl = isInitiator = fut != null && fut.id().equals(reqId);
        if (!isInitiator || fut.isDone()) {
            return false;
        }
        return !F.isEmpty(err) ? fut.onDone(F.firstValue(err)) : fut.onDone();
    }

    private static class GroupKeyChangeFuture
    extends GridEncryptionManager.KeyChangeFuture {
        private final ChangeCacheEncryptionRequest req;

        GroupKeyChangeFuture(ChangeCacheEncryptionRequest req) {
            super(req.requestId());
            this.req = req;
        }

        public ChangeCacheEncryptionRequest request() {
            return this.req;
        }

        @Override
        public String toString() {
            return S.toString(GroupKeyChangeFuture.class, this);
        }
    }
}

