/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.platform.client.ClientAffinityTopologyVersion;
import org.apache.ignite.internal.processors.platform.client.ClientBitmaskFeature;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionAwarenessGroup;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionMapping;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionsResponse;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.lang.gridfunc.NotContainsPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class ClientCachePartitionsRequest
extends ClientRequest {
    private final int[] cacheIds;
    private final boolean withCustomMappings;

    public ClientCachePartitionsRequest(BinaryRawReader reader, ClientProtocolContext protocolCtx) {
        super(reader);
        this.withCustomMappings = protocolCtx.isFeatureSupported(ClientBitmaskFeature.ALL_AFFINITY_MAPPINGS) ? reader.readBoolean() : false;
        int len = reader.readInt();
        this.cacheIds = new int[len];
        for (int i = 0; i < len; ++i) {
            this.cacheIds[i] = reader.readInt();
        }
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        ClientCachePartitionAwarenessGroup grp;
        if (!ctx.kernalContext().state().publicApiActiveState(true)) {
            return new ClientResponse(this.requestId(), "Cannot perform cache operation because the cluster is inactive.");
        }
        HashMap<ClientCachePartitionAwarenessGroup, ClientCachePartitionAwarenessGroup> grps = new HashMap<ClientCachePartitionAwarenessGroup, ClientCachePartitionAwarenessGroup>(this.cacheIds.length);
        ClientAffinityTopologyVersion affVer = ctx.checkAffinityTopologyVersion();
        Set affectedGrpIds = Arrays.stream(this.cacheIds).mapToObj(id -> ctx.kernalContext().cache().cacheDescriptor(id)).filter(Objects::nonNull).map(DynamicCacheDescriptor::groupId).collect(Collectors.toSet());
        Map<Integer, List<DynamicCacheDescriptor>> allCaches = ctx.kernalContext().cache().cacheDescriptors().values().stream().filter(Objects::nonNull).filter(c -> c.cacheType() == CacheType.USER || c.cacheType() == CacheType.DATA_STRUCTURES).collect(Collectors.groupingBy(DynamicCacheDescriptor::groupId));
        IgnitePredicate[] ignitePredicateArray = new IgnitePredicate[1];
        ignitePredicateArray[0] = affectedGrpIds::contains;
        for (List<DynamicCacheDescriptor> affected : F.view(allCaches, ignitePredicateArray).values()) {
            grp = ClientCachePartitionsRequest.processCache(ctx, affVer, F.first(affected), this.withCustomMappings);
            if (grp == null) continue;
            Optional.ofNullable(grps.putIfAbsent(grp, grp)).orElse(grp).addAll(affected);
        }
        for (List<DynamicCacheDescriptor> descs : F.view(allCaches, new NotContainsPredicate(affectedGrpIds)).values()) {
            ClientCachePartitionAwarenessGroup grp0;
            grp = ClientCachePartitionsRequest.processCache(ctx, affVer, F.first(descs), this.withCustomMappings);
            if (grp == null || (grp0 = (ClientCachePartitionAwarenessGroup)grps.get(grp)) == null) continue;
            grp0.addAll(descs);
        }
        return new ClientCachePartitionsResponse(this.requestId(), new ArrayList<ClientCachePartitionAwarenessGroup>(grps.keySet()), affVer);
    }

    private static ClientCachePartitionAwarenessGroup processCache(ClientConnectionContext ctx, ClientAffinityTopologyVersion affinityVer, DynamicCacheDescriptor cacheDesc, boolean withCustomMappings) {
        AffinityAssignment assignment = ClientCachePartitionsRequest.getCacheAssignment(ctx, affinityVer, cacheDesc.cacheId());
        if (assignment == null) {
            return null;
        }
        ClientCachePartitionMapping mapping = null;
        if (ClientCachePartitionsRequest.isApplicable(cacheDesc.cacheConfiguration(), withCustomMappings)) {
            mapping = new ClientCachePartitionMapping(assignment);
        }
        return new ClientCachePartitionAwarenessGroup(mapping, !withCustomMappings || ClientCachePartitionsRequest.isDefaultMapping(cacheDesc.cacheConfiguration()));
    }

    @Nullable
    private static AffinityAssignment getCacheAssignment(ClientConnectionContext ctx, ClientAffinityTopologyVersion affinityVer, int cacheId) {
        try {
            GridCacheContext cacheCtx = ctx.kernalContext().cache().context().cacheContext(cacheId);
            return cacheCtx.affinity().assignment(affinityVer.getVersion());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isApplicable(CacheConfiguration<?, ?> ccfg, boolean withCustomMappings) {
        if (ccfg.getCacheMode() != CacheMode.PARTITIONED) {
            return false;
        }
        return withCustomMappings || ClientCachePartitionsRequest.isDefaultMapping(ccfg);
    }

    public static boolean isDefaultMapping(CacheConfiguration<?, ?> ccfg) {
        if (QueryUtils.isCustomAffinityMapper(ccfg.getAffinityMapper())) {
            return false;
        }
        return ccfg.getAffinity().getClass().equals(RendezvousAffinityFunction.class);
    }
}

