/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Collection;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.spi.IgnitePortProtocol;

public class GridPluginContext
implements PluginContext {
    private final GridKernalContext ctx;
    private final IgniteConfiguration igniteCfg;

    public GridPluginContext(GridKernalContext ctx, IgniteConfiguration igniteCfg) {
        this.ctx = ctx;
        this.igniteCfg = igniteCfg;
    }

    @Override
    public IgniteConfiguration igniteConfiguration() {
        return this.igniteCfg;
    }

    @Override
    public Ignite grid() {
        return this.ctx.grid();
    }

    @Override
    public MarshallerContext marshallerContext() {
        return this.ctx.marshallerContext();
    }

    @Override
    public Collection<ClusterNode> nodes() {
        return this.ctx.discovery().allNodes();
    }

    @Override
    public ClusterNode localNode() {
        return this.ctx.discovery().localNode();
    }

    @Override
    public IgniteLogger log(Class<?> cls) {
        return this.ctx.log(cls);
    }

    @Override
    public void registerPort(int port, IgnitePortProtocol proto, Class<?> cls) {
        this.ctx.ports().registerPort(port, proto, cls);
    }

    @Override
    public void deregisterPort(int port, IgnitePortProtocol proto, Class<?> cls) {
        this.ctx.ports().deregisterPort(port, proto, cls);
    }

    @Override
    public void deregisterPorts(Class<?> cls) {
        this.ctx.ports().deregisterPorts(cls);
    }
}

