/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot.dump;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntryVersion;
import org.apache.ignite.dump.DumpEntry;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.wal.record.UnwrapDataEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.jetbrains.annotations.Nullable;

public class DumpEntrySerializer {
    public static final int HEADER_SZ = 8;
    private static final Function<Long, ByteBuffer> DFLT_BUF_ALLOC = k -> ByteBuffer.allocate(100);
    private final ConcurrentMap<Long, ByteBuffer> thLocBufs;
    @Nullable
    private final ConcurrentMap<Long, ByteBuffer> encThLocBufs;
    @Nullable
    private final EncryptionSpi encSpi;
    @Nullable
    private final Serializable encKey;
    private final FastCrc crc = new FastCrc();
    private IgniteCacheObjectProcessor co;
    private CacheObjectContext fakeCacheObjCtx;
    private boolean raw;
    private boolean keepBinary;

    public DumpEntrySerializer(ConcurrentMap<Long, ByteBuffer> thLocBufs, @Nullable ConcurrentMap<Long, ByteBuffer> encThLocBufs, @Nullable Serializable encKey, @Nullable EncryptionSpi encSpi) {
        this.thLocBufs = thLocBufs;
        this.encThLocBufs = encThLocBufs;
        this.encKey = encKey;
        this.encSpi = encSpi;
    }

    public void kernalContext(GridKernalContext cctx) {
        this.co = cctx.cacheObjects();
        this.fakeCacheObjCtx = new CacheObjectContext(cctx, null, null, false, false, false, false, false);
    }

    public void keepBinary(boolean keepBinary) {
        this.keepBinary = keepBinary;
    }

    public void raw(boolean raw) {
        this.raw = raw;
    }

    public ByteBuffer writeToBuffer(int cache, long expireTime, KeyCacheObject key, CacheObject val, GridCacheVersion ver, CacheObjectContext coCtx) throws IgniteCheckedException {
        ByteBuffer plainBuf = this.writeToBufferPlain(cache, expireTime, key, val, ver, coCtx);
        if (this.encKey == null) {
            return plainBuf;
        }
        int encDataSz = 4 + this.encSpi.encryptedSize(plainBuf.limit());
        ByteBuffer encBuf = this.threadLocalBuffer(this.encThLocBufs);
        if (encBuf.capacity() < encDataSz) {
            encBuf = this.enlargeThreadLocalBuffer(this.encThLocBufs, encDataSz);
        } else {
            encBuf.rewind().limit(encDataSz);
        }
        encBuf.putInt(encDataSz - 4);
        this.encSpi.encrypt(plainBuf, this.encKey, encBuf);
        encBuf.position(0);
        return encBuf;
    }

    private ByteBuffer writeToBufferPlain(int cache, long expireTime, KeyCacheObject key, CacheObject val, GridCacheVersion ver, CacheObjectContext coCtx) throws IgniteCheckedException {
        int dataSz = DumpEntrySerializer.plainDataSize(key, val, ver, coCtx);
        int bufSz = dataSz + 4;
        ByteBuffer buf = this.threadLocalBuffer(this.thLocBufs);
        if (buf.capacity() < bufSz) {
            buf = this.enlargeThreadLocalBuffer(this.thLocBufs, bufSz);
        } else {
            buf.rewind().limit(bufSz);
        }
        buf.putInt(dataSz);
        buf.putInt(-1);
        buf.putInt(cache);
        buf.putLong(expireTime);
        boolean hasConflictVer = ver.otherClusterVersion() != null;
        buf.put((byte)(hasConflictVer ? 1 : 0));
        buf.putInt(ver.topologyVersion());
        buf.putLong(ver.order());
        buf.putInt(ver.nodeOrderAndDrIdRaw());
        if (hasConflictVer) {
            GridCacheVersion ver0 = (GridCacheVersion)ver.otherClusterVersion();
            buf.putInt(ver0.topologyVersion());
            buf.putLong(ver0.order());
            buf.putInt(ver0.nodeOrderAndDrIdRaw());
        }
        if (!key.putValue(buf)) {
            throw new IgniteCheckedException("Can't write key");
        }
        if (!val.putValue(buf)) {
            throw new IgniteCheckedException("Can't write value");
        }
        assert (buf.position() == bufSz);
        buf.position(8);
        this.crc.reset();
        this.crc.update(buf, dataSz - 4);
        buf.position(4);
        buf.putInt(this.crc.getValue());
        buf.position(0);
        return buf;
    }

    private static int plainDataSize(KeyCacheObject key, CacheObject val, GridCacheVersion ver, CacheObjectContext coCtx) throws IgniteCheckedException {
        boolean hasConflictVer;
        int verSz = 16;
        boolean bl = hasConflictVer = ver.otherClusterVersion() != null;
        if (hasConflictVer) {
            verSz *= 2;
        }
        assert (ver.fieldsCount() == (hasConflictVer ? (byte)4 : 3));
        int keySz = key.valueBytesLength(coCtx);
        int valSz = val.valueBytesLength(coCtx);
        return 17 + verSz + keySz + valSz;
    }

    public DumpEntry read(FileIO dumpFile, int grp, int part) throws IOException, IgniteCheckedException {
        assert (this.co != null) : "Set kernalContext first";
        ByteBuffer buf = this.readRecord(dumpFile);
        if (buf == null) {
            return null;
        }
        if (this.encSpi != null) {
            ByteBuffer plainBuf = this.threadLocalBuffer(this.encThLocBufs);
            plainBuf.limit(plainBuf.capacity());
            if (plainBuf.capacity() < buf.limit()) {
                plainBuf = this.enlargeThreadLocalBuffer(this.encThLocBufs, buf.limit());
            } else {
                plainBuf.rewind();
            }
            buf.position(4);
            this.encSpi.decryptNoPadding(buf, this.encKey, plainBuf);
            plainBuf.rewind();
            int plainDataSz = plainBuf.getInt();
            plainBuf.limit(plainDataSz + 4);
            buf = plainBuf;
        }
        return this.plainDataEntry(part, buf);
    }

    private ByteBuffer readRecord(FileIO file) throws IOException {
        ByteBuffer buf = this.threadLocalBuffer(this.thLocBufs);
        buf.position(0);
        buf.limit(4);
        int read = file.readFully(buf);
        if (read < 4) {
            return null;
        }
        buf.position(0);
        int dataSz = buf.getInt();
        int bufSz = dataSz + 4;
        if (buf.capacity() < bufSz) {
            buf = this.enlargeThreadLocalBuffer(this.thLocBufs, bufSz);
            buf.position(4);
        } else {
            buf.limit(bufSz);
        }
        read = file.readFully(buf);
        if (read != buf.limit() - 4) {
            throw new IgniteException("Expected to read " + (buf.limit() - 4) + " bytes but read only " + read);
        }
        return buf;
    }

    private DumpEntry plainDataEntry(int part, ByteBuffer buf) throws IgniteCheckedException {
        buf.position(4);
        int crc = buf.getInt();
        this.checkCRC(crc, buf);
        buf.position(8);
        final int cache = buf.getInt();
        final long expireTime = buf.getLong();
        final GridCacheVersion ver = DumpEntrySerializer.readVersion(buf);
        int keySz = buf.getInt();
        byte keyType = buf.get();
        byte[] keyBytes = new byte[keySz];
        buf.get(keyBytes, 0, keyBytes.length);
        final KeyCacheObject key = this.co.toKeyCacheObject(this.fakeCacheObjCtx, keyType, keyBytes);
        if (key.partition() == -1) {
            key.partition(part);
        }
        int valSz = buf.getInt();
        byte valType = buf.get();
        byte[] valBytes = new byte[valSz];
        buf.get(valBytes, 0, valBytes.length);
        final CacheObject val = this.co.toCacheObject(this.fakeCacheObjCtx, valType, valBytes);
        return new DumpEntry(){

            @Override
            public int cacheId() {
                return cache;
            }

            @Override
            public long expireTime() {
                return expireTime;
            }

            @Override
            public CacheEntryVersion version() {
                return ver;
            }

            @Override
            public Object key() {
                return DumpEntrySerializer.this.raw ? key : UnwrapDataEntry.unwrapKey(key, DumpEntrySerializer.this.keepBinary, DumpEntrySerializer.this.fakeCacheObjCtx);
            }

            @Override
            public Object value() {
                return DumpEntrySerializer.this.raw ? val : UnwrapDataEntry.unwrapValue(val, DumpEntrySerializer.this.keepBinary, DumpEntrySerializer.this.fakeCacheObjCtx);
            }
        };
    }

    private static GridCacheVersion readVersion(ByteBuffer buf) {
        boolean hasConflictVer = buf.get() == 1;
        int topVer = buf.getInt();
        long order = buf.getLong();
        int nodeOrderDrId = buf.getInt();
        if (!hasConflictVer) {
            return new GridCacheVersion(topVer, nodeOrderDrId, order);
        }
        int topVer0 = buf.getInt();
        long order0 = buf.getLong();
        int nodeOrderDrId0 = buf.getInt();
        return new GridCacheVersionEx(topVer, nodeOrderDrId, order, new GridCacheVersion(topVer0, nodeOrderDrId0, order0));
    }

    private ByteBuffer threadLocalBuffer(ConcurrentMap<Long, ByteBuffer> map) {
        ByteBuffer res = map.computeIfAbsent(Thread.currentThread().getId(), DFLT_BUF_ALLOC);
        res.limit(res.capacity());
        res.position(0);
        return res;
    }

    private ByteBuffer enlargeThreadLocalBuffer(ConcurrentMap<Long, ByteBuffer> map, int sz) {
        ByteBuffer buf = ByteBuffer.allocate(sz);
        map.put(Thread.currentThread().getId(), buf);
        return buf;
    }

    private void checkCRC(int expCrc, ByteBuffer buf) {
        this.crc.reset();
        this.crc.update(buf, buf.limit() - buf.position());
        if (expCrc != this.crc.getValue()) {
            throw new IgniteException("Data corrupted [expCrc=" + expCrc + ", crc=" + this.crc + "]");
        }
    }
}

