/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.datastructures;

import java.util.Iterator;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetRequest;

public class ClientIgniteSetIteratorStartRequest
extends ClientIgniteSetRequest {
    private final int pageSize;

    public ClientIgniteSetIteratorStartRequest(BinaryRawReader reader) {
        super(reader);
        this.pageSize = reader.readInt();
    }

    @Override
    protected ClientResponse process(IgniteSet<Object> set) {
        return new Response(this.requestId(), set.iterator());
    }

    static void writePage(BinaryRawWriterEx writer, Iterator iter, int pageSize) {
        int cnt;
        int cntPos = writer.reserveInt();
        for (cnt = 0; cnt < pageSize && iter.hasNext(); ++cnt) {
            writer.writeObject(iter.next());
        }
        writer.writeInt(cntPos, cnt);
        writer.writeBoolean(iter.hasNext());
    }

    private class Response
    extends ClientResponse {
        private final Iterator iter;

        public Response(long reqId, Iterator iter) {
            super(reqId);
            this.iter = iter;
        }

        @Override
        public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
            super.encode(ctx, writer);
            ClientIgniteSetIteratorStartRequest.writePage(writer, this.iter, ClientIgniteSetIteratorStartRequest.this.pageSize);
            if (this.iter.hasNext()) {
                long resId = ctx.resources().put(this.iter);
                writer.writeLong(resId);
            }
        }
    }
}

