/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import org.apache.ignite.spi.systemview.view.MetricsView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link MetricsView} attributes walker.
 * 
 * @see MetricsView
 */
public class MetricsViewWalker implements SystemViewRowAttributeWalker<MetricsView> {
    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "name", String.class);
        v.accept(1, "value", String.class);
        v.accept(2, "description", String.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(MetricsView row, AttributeWithValueVisitor v) {
        v.accept(0, "name", String.class, row.name());
        v.accept(1, "value", String.class, row.value());
        v.accept(2, "description", String.class, row.description());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 3;
    }
}
