/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cdc;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cdc.CdcManager;
import org.apache.ignite.internal.pagemem.wal.record.CdcManagerStopRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CdcUtilityActiveCdcManager
extends GridCacheSharedManagerAdapter
implements CdcManager,
PartitionsExchangeAware {
    @Override
    protected void start0() {
        this.cctx.exchange().registerExchangeAwareComponent(this);
    }

    @Override
    public void onDoneAfterTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
        if (fut.localJoinExchange() || fut.activateCluster()) {
            try {
                File cdcModeFile = Paths.get(((FileWriteAheadLogManager)this.cctx.wal(true)).walCdcDirectory().getAbsolutePath(), "state", "cdc-mode.bin").toFile();
                if (!cdcModeFile.exists()) {
                    this.cctx.wal(true).log(new CdcManagerStopRecord());
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to activate CdcManager. CDC might not work.");
            }
            finally {
                this.cctx.exchange().unregisterExchangeAwareComponent(this);
            }
        }
    }

    @Override
    public boolean enabled() {
        return false;
    }

    @Override
    public void collect(ByteBuffer dataBuf) {
    }
}

