/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.datastructures;

import java.util.Iterator;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientIgniteSetIteratorStartRequest;

public class ClientIgniteSetIteratorGetPageRequest
extends ClientRequest {
    private final int pageSize;
    private final long resId;

    public ClientIgniteSetIteratorGetPageRequest(BinaryRawReader reader) {
        super(reader);
        this.resId = reader.readLong();
        this.pageSize = reader.readInt();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        return new Response(this.requestId(), (Iterator)ctx.resources().get(this.resId));
    }

    private class Response
    extends ClientResponse {
        private final Iterator iter;

        public Response(long reqId, Iterator iter) {
            super(reqId);
            this.iter = iter;
        }

        @Override
        public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
            super.encode(ctx, writer);
            ClientIgniteSetIteratorStartRequest.writePage(writer, this.iter, ClientIgniteSetIteratorGetPageRequest.this.pageSize);
            if (!this.iter.hasNext()) {
                ctx.resources().release(ClientIgniteSetIteratorGetPageRequest.this.resId);
            }
        }
    }
}

