/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.websession;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class WebSessionEntity
implements Serializable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private String id;
    private long createTime;
    private long accessTime;
    private int maxInactiveInterval;
    @GridToStringExclude
    private Map<String, byte[]> attrs;

    public WebSessionEntity() {
    }

    public WebSessionEntity(String id, long createTime, long accessTime, int maxInactiveInterval) {
        this.id = id;
        this.createTime = createTime;
        this.accessTime = accessTime;
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public WebSessionEntity(WebSessionEntity other) {
        this(other.id(), other.createTime(), other.accessTime(), other.maxInactiveInterval());
        if (!other.attributes().isEmpty()) {
            this.attrs = new HashMap<String, byte[]>(other.attributes());
        }
    }

    public String id() {
        return this.id;
    }

    public long createTime() {
        return this.createTime;
    }

    public long accessTime() {
        return this.accessTime;
    }

    public void accessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public int maxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void maxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public Map<String, byte[]> attributes() {
        return this.attrs == null ? Collections.emptyMap() : this.attrs;
    }

    public void putAttribute(String name, byte[] val) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, byte[]>();
        }
        this.attrs.put(name, val);
    }

    public void removeAttribute(String name) {
        if (this.attrs != null) {
            this.attrs.remove(name);
        }
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter rawWriter = writer.rawWriter();
        rawWriter.writeString(this.id);
        rawWriter.writeLong(this.createTime);
        rawWriter.writeLong(this.accessTime);
        rawWriter.writeInt(this.maxInactiveInterval);
        rawWriter.writeMap(this.attrs);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader rawReader = reader.rawReader();
        this.id = rawReader.readString();
        this.createTime = rawReader.readLong();
        this.accessTime = rawReader.readLong();
        this.maxInactiveInterval = rawReader.readInt();
        this.attrs = rawReader.readMap();
    }

    public String toString() {
        return S.toString(WebSessionEntity.class, this, "attributes", this.attrs != null ? this.attrs.keySet() : Collections.emptySet());
    }
}

