/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.jetbrains.annotations.Nullable;

public class HybridTimestamps {
    @Nullable
    public static HybridTimestamp readTimestamp(long pageAddr, int offset) {
        long time = PageUtils.getLong((long)pageAddr, (int)offset);
        return HybridTimestamp.nullableHybridTimestamp((long)time);
    }

    public static int writeTimestampToMemory(long addr, int offset, @Nullable HybridTimestamp timestamp) {
        PageUtils.putLong((long)addr, (int)offset, (long)HybridTimestamp.hybridTimestampToLong((HybridTimestamp)timestamp));
        return 8;
    }

    public static void writeTimestampToBuffer(ByteBuffer buffer, @Nullable HybridTimestamp timestamp) {
        buffer.putLong(HybridTimestamp.hybridTimestampToLong((HybridTimestamp)timestamp));
    }
}

