/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class CatalogSystemViewDescriptor
extends CatalogObjectDescriptor {
    public static final CatalogObjectSerializer<CatalogSystemViewDescriptor> SERIALIZER = new SystemViewDescriptorSerializer();
    private final int schemaId;
    private final List<CatalogTableColumnDescriptor> columns;
    private final SystemViewType systemViewType;

    public CatalogSystemViewDescriptor(int id, int schemaId, String name, List<CatalogTableColumnDescriptor> columns, SystemViewType systemViewType) {
        this(id, schemaId, name, columns, systemViewType, 0L);
    }

    public CatalogSystemViewDescriptor(int id, int schemaId, String name, List<CatalogTableColumnDescriptor> columns, SystemViewType systemViewType, long causalityToken) {
        super(id, CatalogObjectDescriptor.Type.SYSTEM_VIEW, name, causalityToken);
        this.schemaId = schemaId;
        this.columns = Objects.requireNonNull(columns, "columns");
        this.systemViewType = Objects.requireNonNull(systemViewType, "viewType");
    }

    public int schemaId() {
        return this.schemaId;
    }

    public List<CatalogTableColumnDescriptor> columns() {
        return this.columns;
    }

    public SystemViewType systemViewType() {
        return this.systemViewType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogSystemViewDescriptor that = (CatalogSystemViewDescriptor)o;
        return this.schemaId == that.schemaId && Objects.equals(this.columns, that.columns) && this.systemViewType == that.systemViewType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaId, this.columns, this.systemViewType});
    }

    @Override
    public String toString() {
        return S.toString(CatalogSystemViewDescriptor.class, (Object)this, (String)"id", (Object)this.id(), (String)"schemaId", (Object)this.schemaId, (String)"name", (Object)this.name(), (String)"columns", this.columns, (String)"systemViewType", (Object)((Object)this.systemViewType()));
    }

    public static enum SystemViewType {
        NODE(0),
        CLUSTER(1);

        private final int id;

        private SystemViewType(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        private static SystemViewType forId(int id) {
            switch (id) {
                case 0: {
                    return NODE;
                }
                case 1: {
                    return CLUSTER;
                }
            }
            throw new IllegalArgumentException("Unknown system view type id: " + id);
        }
    }

    private static class SystemViewDescriptorSerializer
    implements CatalogObjectSerializer<CatalogSystemViewDescriptor> {
        private SystemViewDescriptorSerializer() {
        }

        @Override
        public CatalogSystemViewDescriptor readFrom(IgniteDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            int schemaId = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateToken = input.readVarInt();
            List<CatalogTableColumnDescriptor> columns = CatalogSerializationUtils.readList(CatalogTableColumnDescriptor.SERIALIZER, input);
            byte sysViewTypeId = input.readByte();
            SystemViewType sysViewType = SystemViewType.forId(sysViewTypeId);
            return new CatalogSystemViewDescriptor(id, schemaId, name, columns, sysViewType, updateToken);
        }

        @Override
        public void writeTo(CatalogSystemViewDescriptor descriptor, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)descriptor.id());
            output.writeVarInt((long)descriptor.schemaId);
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateToken());
            CatalogSerializationUtils.writeList(descriptor.columns(), CatalogTableColumnDescriptor.SERIALIZER, output);
            output.writeByte(descriptor.systemViewType().id());
        }
    }
}

