/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.tx.DeadlockPreventionPolicy;
import org.apache.ignite.internal.tx.impl.TxIdPriorityComparator;
import org.jetbrains.annotations.Nullable;

public class DeadlockPreventionPolicyImpl
implements DeadlockPreventionPolicy {
    private final Comparator<UUID> txIdComparator;
    private final long waitTimeout;

    public DeadlockPreventionPolicyImpl(String txIdComparator, long waitTimeout) {
        this(TxIdComparators.valueOf(Objects.requireNonNull(txIdComparator)), waitTimeout);
    }

    public DeadlockPreventionPolicyImpl(TxIdComparators txIdComparator, long waitTimeout) {
        switch (txIdComparator.ordinal()) {
            case 0: {
                this.txIdComparator = new TxIdPriorityComparator();
                break;
            }
            case 1: {
                this.txIdComparator = new TxIdPriorityComparator().reversed();
                break;
            }
            case 2: {
                this.txIdComparator = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown comparator type: " + String.valueOf((Object)txIdComparator));
            }
        }
        this.waitTimeout = waitTimeout;
    }

    @Override
    @Nullable
    public Comparator<UUID> txIdComparator() {
        return this.txIdComparator;
    }

    @Override
    public long waitTimeout() {
        return this.waitTimeout;
    }

    public static enum TxIdComparators {
        NATURAL,
        REVERSED,
        NONE;

    }
}

