/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaResponse;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TransactionResult;
import org.apache.ignite.internal.tx.configuration.TransactionConfiguration;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateResponse;
import org.jetbrains.annotations.Nullable;

public class TxMessageSender {
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final MessagingService messagingService;
    private final ReplicaService replicaService;
    private final ClockService clockService;
    private final TransactionConfiguration transactionConfiguration;

    public TxMessageSender(MessagingService messagingService, ReplicaService replicaService, ClockService clockService, TransactionConfiguration transactionConfiguration) {
        this.messagingService = messagingService;
        this.replicaService = replicaService;
        this.clockService = clockService;
        this.transactionConfiguration = transactionConfiguration;
    }

    public CompletableFuture<ReplicaResponse> switchWriteIntents(String primaryConsistentId, TablePartitionId tablePartitionId, UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        return this.replicaService.invoke(primaryConsistentId, (ReplicaRequest)TX_MESSAGES_FACTORY.writeIntentSwitchReplicaRequest().groupId((ReplicationGroupIdMessage)ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)tablePartitionId)).timestamp(this.clockService.now()).txId(txId).commit(commit).commitTimestamp(commitTimestamp).build());
    }

    public CompletableFuture<NetworkMessage> cleanup(String primaryConsistentId, @Nullable Collection<TablePartitionId> replicationGroupIds, UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        return this.messagingService.invoke(primaryConsistentId, (NetworkMessage)TX_MESSAGES_FACTORY.txCleanupMessage().txId(txId).commit(commit).commitTimestamp(commitTimestamp).timestamp(this.clockService.now()).groups(TxMessageSender.toTablePartitionIdMessages(replicationGroupIds)).build(), ((Long)this.transactionConfiguration.rpcTimeout().value()).longValue());
    }

    public CompletableFuture<TransactionResult> finish(String primaryConsistentId, TablePartitionId commitPartition, Map<TablePartitionId, String> replicationGroupIds, UUID txId, Long consistencyToken, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        TablePartitionIdMessage commitPartitionIdMessage = REPLICA_MESSAGES_FACTORY.tablePartitionIdMessage().partitionId(commitPartition.partitionId()).tableId(commitPartition.tableId()).build();
        return this.replicaService.invoke(primaryConsistentId, (ReplicaRequest)TX_MESSAGES_FACTORY.txFinishReplicaRequest().txId(txId).commitPartitionId(commitPartitionIdMessage).timestamp(this.clockService.now()).groupId((ReplicationGroupIdMessage)ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)commitPartition)).groups(TxMessageSender.toTablePartitionIdMessages(replicationGroupIds)).commit(commit).commitTimestamp(commitTimestamp).enlistmentConsistencyToken(consistencyToken).build());
    }

    public CompletableFuture<TransactionMeta> resolveTxStateFromCommitPartition(String primaryConsistentId, UUID txId, TablePartitionId commitGrpId, Long consistencyToken) {
        return this.replicaService.invoke(primaryConsistentId, (ReplicaRequest)TX_MESSAGES_FACTORY.txStateCommitPartitionRequest().groupId((ReplicationGroupIdMessage)ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)commitGrpId)).txId(txId).enlistmentConsistencyToken(consistencyToken).build());
    }

    public CompletableFuture<TxStateResponse> resolveTxStateFromCoordinator(String primaryConsistentId, UUID txId, HybridTimestamp timestamp) {
        return this.messagingService.invoke(primaryConsistentId, (NetworkMessage)TX_MESSAGES_FACTORY.txStateCoordinatorRequest().readTimestamp(timestamp).txId(txId).build(), ((Long)this.transactionConfiguration.rpcTimeout().value()).longValue()).thenApply(resp -> {
            assert (resp instanceof TxStateResponse) : "Unsupported response type [type=" + resp.getClass().getSimpleName() + "]";
            return (TxStateResponse)resp;
        });
    }

    public CompletableFuture<ReplicaResponse> sendRecoveryCleanup(String primaryConsistentId, TablePartitionId tablePartitionId) {
        return this.replicaService.invoke(primaryConsistentId, (ReplicaRequest)TX_MESSAGES_FACTORY.txCleanupRecoveryRequest().groupId((ReplicationGroupIdMessage)ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)tablePartitionId)).build());
    }

    public MessagingService messagingService() {
        return this.messagingService;
    }

    @Nullable
    private static List<TablePartitionIdMessage> toTablePartitionIdMessages(@Nullable Collection<TablePartitionId> tablePartitionIds) {
        if (tablePartitionIds == null) {
            return null;
        }
        ArrayList<TablePartitionIdMessage> messages = new ArrayList<TablePartitionIdMessage>(tablePartitionIds.size());
        for (TablePartitionId tablePartitionId : tablePartitionIds) {
            messages.add(ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)tablePartitionId));
        }
        return messages;
    }

    private static Map<TablePartitionIdMessage, String> toTablePartitionIdMessages(Map<TablePartitionId, String> replicationGroupIds) {
        HashMap<TablePartitionIdMessage, String> messages = new HashMap<TablePartitionIdMessage, String>(replicationGroupIds.size());
        for (Map.Entry<TablePartitionId, String> e : replicationGroupIds.entrySet()) {
            messages.put(ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)e.getKey()), e.getValue());
        }
        return messages;
    }
}

