/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PartitionProcessingCounter;
import org.jetbrains.annotations.Nullable;

public class PartitionProcessingCounterMap {
    private final ConcurrentMap<GroupPartitionId, PartitionProcessingCounter> processedPartitions = new ConcurrentHashMap<GroupPartitionId, PartitionProcessingCounter>();

    public void incrementPartitionProcessingCounter(GroupPartitionId groupPartitionId) {
        this.processedPartitions.compute(groupPartitionId, (id, partitionProcessingCounter) -> {
            if (partitionProcessingCounter == null) {
                PartitionProcessingCounter counter = new PartitionProcessingCounter();
                counter.incrementPartitionProcessingCounter();
                return counter;
            }
            partitionProcessingCounter.incrementPartitionProcessingCounter();
            return partitionProcessingCounter;
        });
    }

    public void decrementPartitionProcessingCounter(GroupPartitionId groupPartitionId) {
        this.processedPartitions.compute(groupPartitionId, (id, partitionProcessingCounter) -> {
            assert (partitionProcessingCounter != null) : id;
            assert (!partitionProcessingCounter.future().isDone()) : id;
            partitionProcessingCounter.decrementPartitionProcessingCounter();
            return partitionProcessingCounter.future().isDone() ? null : partitionProcessingCounter;
        });
    }

    @Nullable
    public CompletableFuture<Void> getProcessedPartitionFuture(GroupPartitionId groupPartitionId) {
        PartitionProcessingCounter partitionProcessingCounter = (PartitionProcessingCounter)this.processedPartitions.get(groupPartitionId);
        return partitionProcessingCounter == null ? null : partitionProcessingCounter.future();
    }
}

