/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.tree.io;

import java.util.function.Consumer;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.pagememory.util.PartitionlessLinks;
import org.jetbrains.annotations.Nullable;

public abstract class BplusIo<L>
extends PageIo {
    private static final int CNT_OFF = 40;
    private static final int FORWARD_OFF = 42;
    private static final int REMOVE_ID_OFF = 48;
    protected static final int ITEMS_OFF = 56;
    public static final int HEADER_SIZE = 56;
    private final boolean canGetRow;
    private final boolean leaf;
    protected final int itemSize;

    protected BplusIo(int type, int ver, boolean leaf, boolean canGetRow, int itemSize) {
        super(type, ver, (byte)2);
        assert (itemSize > 0) : itemSize;
        assert (canGetRow || !leaf) : "leaf page always must be able to get full row";
        this.leaf = leaf;
        this.canGetRow = canGetRow;
        this.itemSize = itemSize;
    }

    public final int getItemSize() {
        return this.itemSize;
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setCount(pageAddr, 0);
        this.setForward(pageAddr, 0L);
        this.setRemoveId(pageAddr, 0L);
    }

    public final long getForward(long pageAddr, int partId) {
        return PartitionlessLinks.readPartitionless(partId, pageAddr, 42);
    }

    public final void setForward(long pageAddr, long pageId) {
        this.assertPageType(pageAddr);
        PartitionlessLinks.writePartitionless(pageAddr + 42L, pageId);
        assert (this.getForward(pageAddr, PageIdUtils.partitionId(pageId)) == pageId);
    }

    public final long getRemoveId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 48);
    }

    public final void setRemoveId(long pageAddr, long rmvId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 48, rmvId);
        assert (this.getRemoveId(pageAddr) == rmvId);
    }

    public final int getCount(long pageAddr) {
        return PageUtils.getShort(pageAddr, 40) & 0xFFFF;
    }

    public final void setCount(long pageAddr, int cnt) {
        this.assertPageType(pageAddr);
        assert (cnt >= 0) : cnt;
        PageUtils.putShort(pageAddr, 40, (short)cnt);
        assert (this.getCount(pageAddr) == cnt);
    }

    public final boolean canGetRow() {
        return this.canGetRow;
    }

    public final boolean isLeaf() {
        return this.leaf;
    }

    public abstract int getMaxCount(long var1, int var3);

    public final byte @Nullable [] store(long pageAddr, int idx, @Nullable L row, byte @Nullable [] rowBytes, boolean needRowBytes) throws IgniteInternalCheckedException {
        this.assertPageType(pageAddr);
        int off = this.offset(idx);
        if (rowBytes == null) {
            this.storeByOffset(pageAddr, off, row);
            if (needRowBytes) {
                rowBytes = PageUtils.getBytes(pageAddr, off, this.getItemSize());
            }
        } else {
            BplusIo.putBytes(pageAddr, off, rowBytes);
        }
        return rowBytes;
    }

    public abstract void store(long var1, int var3, BplusIo<L> var4, long var5, int var7) throws IgniteInternalCheckedException;

    public abstract int offset(int var1);

    public abstract void storeByOffset(long var1, int var3, L var4) throws IgniteInternalCheckedException;

    public abstract L getLookupRow(BplusTree<L, ?> var1, long var2, int var4) throws IgniteInternalCheckedException;

    public abstract void copyItems(long var1, long var3, int var5, int var6, int var7, boolean var8) throws IgniteInternalCheckedException;

    public byte @Nullable [] insert(long pageAddr, int idx, @Nullable L row, byte @Nullable [] rowBytes, long rightId, boolean needRowBytes) throws IgniteInternalCheckedException {
        this.assertPageType(pageAddr);
        int cnt = this.getCount(pageAddr);
        this.copyItems(pageAddr, pageAddr, idx, idx + 1, cnt - idx, false);
        this.setCount(pageAddr, cnt + 1);
        return this.store(pageAddr, idx, row, rowBytes, needRowBytes);
    }

    public void splitForwardPage(long pageAddr, long fwdId, long fwdPageAddr, int mid, int cnt, int pageSize, int partId) throws IgniteInternalCheckedException {
        this.assertPageType(pageAddr);
        this.initNewPage(fwdPageAddr, fwdId, pageSize);
        this.copyItems(pageAddr, fwdPageAddr, mid, 0, cnt -= mid, true);
        this.setCount(fwdPageAddr, cnt);
        this.setForward(fwdPageAddr, this.getForward(pageAddr, partId));
        this.setRemoveId(fwdPageAddr, this.getRemoveId(pageAddr));
    }

    public void splitExistingPage(long pageAddr, int mid, long fwdId) {
        this.assertPageType(pageAddr);
        this.setCount(pageAddr, mid);
        this.setForward(pageAddr, fwdId);
    }

    public void remove(long pageAddr, int idx, int cnt) throws IgniteInternalCheckedException {
        this.assertPageType(pageAddr);
        this.copyItems(pageAddr, pageAddr, idx + 1, idx, --cnt - idx, false);
        this.setCount(pageAddr, cnt);
    }

    public boolean merge(BplusIo<L> parentIo, long parentPageAddr, int parentIdx, long leftPageAddr, long rightPageAddr, boolean emptyBranch, int pageSize) throws IgniteInternalCheckedException {
        this.assertPageType(leftPageAddr);
        int parentCnt = parentIo.getCount(parentPageAddr);
        int leftCnt = this.getCount(leftPageAddr);
        int rightCnt = this.getCount(rightPageAddr);
        int newCnt = leftCnt + rightCnt;
        if (!this.isLeaf() && !emptyBranch) {
            ++newCnt;
        }
        if (newCnt > this.getMaxCount(leftPageAddr, pageSize)) {
            assert (!emptyBranch);
            return false;
        }
        this.setCount(leftPageAddr, newCnt);
        if (!this.isLeaf() && !emptyBranch) {
            assert (parentIdx >= 0 && parentIdx < parentCnt) : parentIdx;
            this.store(leftPageAddr, leftCnt, parentIo, parentPageAddr, parentIdx);
            ++leftCnt;
        }
        this.copyItems(rightPageAddr, leftPageAddr, 0, leftCnt, rightCnt, !emptyBranch);
        this.setForward(leftPageAddr, this.getForward(rightPageAddr, -1));
        long rmvId = this.getRemoveId(rightPageAddr);
        if (rmvId > this.getRemoveId(leftPageAddr)) {
            this.setRemoveId(leftPageAddr, rmvId);
        }
        return true;
    }

    private static void putBytes(long pageAddr, int pos, byte[] bytes) {
        PageUtils.putBytes(pageAddr, pos, bytes);
    }

    public void visit(BplusTree<L, ?> tree, long pageAddr, Consumer<L> c) {
    }

    @Override
    protected void printPage(long addr, int pageSize, IgniteStringBuilder sb) {
        sb.app("BPlusIO [\n\tcanGetRow=").app(this.canGetRow).app(",\n\tleaf=").app(this.leaf).app(",\n\titemSize=").app(this.itemSize).app(",\n\tcnt=").app(this.getCount(addr)).app(",\n\tforward=").appendHex(this.getForward(addr, PageIdUtils.partitionId(BplusIo.getPageId(addr)))).app(",\n\tremoveId=").appendHex(this.getRemoveId(addr)).app("\n]");
    }

    public int getItemsEnd(long pageAddr) {
        int cnt = this.getCount(pageAddr);
        return this.offset(cnt);
    }
}

