/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.entity.NodeId;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.util.OnlyForTest;

public class NodeManager {
    private final ConcurrentMap<NodeId, Node> nodeMap = new ConcurrentHashMap<NodeId, Node>();
    private final ConcurrentMap<String, List<Node>> groupMap = new ConcurrentHashMap<String, List<Node>>();

    public boolean add(Node node) {
        NodeId nodeId = node.getNodeId();
        if (this.nodeMap.putIfAbsent(nodeId, node) == null) {
            List existsNode;
            String groupId = node.getGroupId();
            List<Node> nodes = (CopyOnWriteArrayList<Node>)this.groupMap.get(groupId);
            if (nodes == null && (existsNode = (List)this.groupMap.putIfAbsent(groupId, nodes = new CopyOnWriteArrayList<Node>())) != null) {
                nodes = existsNode;
            }
            nodes.add(node);
            return true;
        }
        return false;
    }

    @OnlyForTest
    public void clear() {
        this.groupMap.clear();
        this.nodeMap.clear();
    }

    public boolean remove(Node node) {
        List nodes;
        if (this.nodeMap.remove(node.getNodeId(), node) && (nodes = (List)this.groupMap.get(node.getGroupId())) != null) {
            return nodes.remove(node);
        }
        return false;
    }

    public Node get(String groupId, PeerId peerId) {
        return (Node)this.nodeMap.get(new NodeId(groupId, peerId));
    }

    public List<Node> getNodesByGroupId(String groupId) {
        return (List)this.groupMap.get(groupId);
    }

    public List<Node> getAllNodes() {
        return this.groupMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

