/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.snapshot.remote;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.core.Scheduler;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.option.CopyOptions;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.option.SnapshotCopierOptions;
import org.apache.ignite.raft.jraft.rpc.GetFileRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.RaftClientService;
import org.apache.ignite.raft.jraft.storage.SnapshotThrottle;
import org.apache.ignite.raft.jraft.storage.snapshot.remote.CopySession;
import org.apache.ignite.raft.jraft.storage.snapshot.remote.Session;
import org.apache.ignite.raft.jraft.util.ByteBufferCollector;
import org.apache.ignite.raft.jraft.util.OnlyForTest;
import org.apache.ignite.raft.jraft.util.Utils;

public class RemoteFileCopier {
    private static final IgniteLogger LOG = Loggers.forClass(RemoteFileCopier.class);
    private long readId;
    private RaftClientService rpcService;
    private PeerId peerId;
    private RaftOptions raftOptions;
    private NodeOptions nodeOptions;
    private Scheduler timerManager;
    private SnapshotThrottle snapshotThrottle;

    @OnlyForTest
    long getReaderId() {
        return this.readId;
    }

    @OnlyForTest
    PeerId getPeerId() {
        return this.peerId;
    }

    public boolean init(String uri, SnapshotThrottle snapshotThrottle, SnapshotCopierOptions opts) {
        this.rpcService = opts.getRaftClientService();
        this.timerManager = opts.getTimerManager();
        this.raftOptions = opts.getRaftOptions();
        this.nodeOptions = opts.getNodeOptions();
        this.snapshotThrottle = snapshotThrottle;
        int prefixSize = "remote://".length();
        if (uri == null || !uri.startsWith("remote://")) {
            LOG.error("Invalid uri {}.", new Object[]{uri});
            return false;
        }
        uri = uri.substring(prefixSize);
        int slasPos = uri.indexOf(47);
        String peerId = uri.substring(0, slasPos);
        uri = uri.substring(slasPos + 1);
        try {
            this.readId = Long.parseLong(uri);
            this.peerId = PeerId.parsePeer(peerId);
        }
        catch (Exception e) {
            LOG.error("Fail to parse readerId or endpoint.", (Throwable)e);
            return false;
        }
        if (!this.rpcService.connect(this.peerId)) {
            LOG.error("Fail to init channel to {}.", new Object[]{this.peerId});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyToFile(String source, String destPath, CopyOptions opts) throws IOException, InterruptedException {
        Session session = this.startCopyToFile(source, destPath, opts);
        if (session == null) {
            return false;
        }
        try {
            session.join();
            boolean bl = session.status().isOk();
            return bl;
        }
        finally {
            Utils.closeQuietly(session);
        }
    }

    public Session startCopyToFile(String source, String destPath, CopyOptions opts) throws IOException {
        File file = new File(destPath);
        if (file.exists() && !file.delete()) {
            LOG.error("Fail to delete destPath: {}.", new Object[]{destPath});
            return null;
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file, false){

            @Override
            public void close() throws IOException {
                this.getFD().sync();
                super.close();
            }
        });
        CopySession session = this.newCopySession(source);
        session.setOutputStream(out);
        session.setDestPath(destPath);
        session.setDestBuf(null);
        if (opts != null) {
            session.setCopyOptions(opts);
        }
        session.sendNextRpc();
        return session;
    }

    private CopySession newCopySession(String source) {
        GetFileRequestBuilder reqBuilder = this.raftOptions.getRaftMessagesFactory().getFileRequest().filename(source).readerId(this.readId);
        return new CopySession(this.rpcService, this.timerManager, this.snapshotThrottle, this.raftOptions, this.nodeOptions, reqBuilder, this.peerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy2IoBuffer(String source, ByteBufferCollector destBuf, CopyOptions opt) throws InterruptedException {
        Session session = this.startCopy2IoBuffer(source, destBuf, opt);
        if (session == null) {
            return false;
        }
        try {
            session.join();
            boolean bl = session.status().isOk();
            return bl;
        }
        finally {
            Utils.closeQuietly(session);
        }
    }

    public Session startCopy2IoBuffer(String source, ByteBufferCollector destBuf, CopyOptions opts) {
        CopySession session = this.newCopySession(source);
        session.setOutputStream(null);
        session.setDestBuf(destBuf);
        if (opts != null) {
            session.setCopyOptions(opts);
        }
        session.sendNextRpc();
        return session;
    }
}

