/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.eventlog.api.EventLog;
import org.apache.ignite.internal.eventlog.api.IgniteEventType;
import org.apache.ignite.internal.eventlog.event.EventUser;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.QueryCancelledException;
import org.apache.ignite.internal.sql.engine.QueryEventsFactory;
import org.apache.ignite.internal.sql.engine.QueryProperty;
import org.apache.ignite.internal.sql.engine.SqlOperationContext;
import org.apache.ignite.internal.sql.engine.exec.AsyncDataCursorExt;
import org.apache.ignite.internal.sql.engine.exec.ExecutionService;
import org.apache.ignite.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite.internal.sql.engine.exec.TransactionTracker;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite.internal.sql.engine.exec.fsm.MultiStatementHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.Programs;
import org.apache.ignite.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite.internal.sql.engine.exec.fsm.QueryIdGenerator;
import org.apache.ignite.internal.sql.engine.exec.fsm.QueryInfo;
import org.apache.ignite.internal.sql.engine.prepare.KeyValueGetPlan;
import org.apache.ignite.internal.sql.engine.prepare.KeyValueModifyPlan;
import org.apache.ignite.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite.internal.sql.engine.prepare.PrepareService;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.property.SqlProperties;
import org.apache.ignite.internal.sql.engine.property.SqlPropertiesHelper;
import org.apache.ignite.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite.internal.sql.engine.sql.ParserService;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite.internal.sql.engine.util.cache.Cache;
import org.apache.ignite.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.CancelHandleHelper;
import org.apache.ignite.lang.CancellationToken;
import org.jetbrains.annotations.Nullable;

public class QueryExecutor
implements LifecycleAware {
    private final Cache<String, ParsedResult> queryToParsedResultCache;
    private final ParserService parserService;
    private final Executor executor;
    private final ScheduledExecutorService scheduler;
    private final ClockService clockService;
    private final SchemaSyncService schemaSyncService;
    private final PrepareService prepareService;
    private final CatalogService catalogService;
    private final ExecutionService executionService;
    private final SqlProperties defaultProperties;
    private final TransactionTracker transactionTracker;
    private final QueryIdGenerator idGenerator;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ConcurrentMap<UUID, Query> runningQueries = new ConcurrentHashMap<UUID, Query>();
    private final EventLog eventLog;
    private final QueryEventsFactory eventsFactory;

    public QueryExecutor(String nodeId, CacheFactory cacheFactory, int parsedResultsCacheSize, ParserService parserService, Executor executor, ScheduledExecutorService scheduler, ClockService clockService, SchemaSyncService schemaSyncService, PrepareService prepareService, CatalogService catalogService, ExecutionService executionService, SqlProperties defaultProperties, TransactionTracker transactionTracker, QueryIdGenerator idGenerator, EventLog eventLog) {
        this.queryToParsedResultCache = cacheFactory.create(parsedResultsCacheSize);
        this.parserService = parserService;
        this.executor = executor;
        this.scheduler = scheduler;
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.prepareService = prepareService;
        this.catalogService = catalogService;
        this.executionService = executionService;
        this.defaultProperties = defaultProperties;
        this.transactionTracker = transactionTracker;
        this.idGenerator = idGenerator;
        this.eventLog = eventLog;
        this.eventsFactory = new QueryEventsFactory(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<AsyncSqlCursor<InternalSqlRow>> executeQuery(SqlProperties properties, QueryTransactionContext txContext, String sql, @Nullable CancellationToken cancellationToken, Object[] params) {
        SqlProperties properties0 = SqlPropertiesHelper.chain(properties, this.defaultProperties);
        Query query = new Query(Instant.ofEpochMilli(this.clockService.now().getPhysical()), this, this.idGenerator.next(), sql, properties0, txContext, params);
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        try {
            this.trackQuery(query, cancellationToken);
        }
        finally {
            this.busyLock.leaveBusy();
        }
        long queryTimeout = properties.getOrDefault(QueryProperty.QUERY_TIMEOUT, 0L);
        if (queryTimeout > 0L) {
            query.cancel.setTimeout(this.scheduler, queryTimeout);
        }
        return Programs.QUERY_EXECUTION.run(query).whenComplete((cursor, ex) -> {
            if (cursor != null && query.parsedScript == null) {
                cursor.onClose().thenRun(() -> query.moveTo(ExecutionPhase.TERMINATED));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<AsyncSqlCursor<InternalSqlRow>> executeChildQuery(Query parent, QueryTransactionContext scriptTxContext, int statementNum, ParsedResult parsedQuery, Object[] params, @Nullable CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextCursorFuture) {
        Query query = new Query(Instant.ofEpochMilli(this.clockService.now().getPhysical()), parent, parsedQuery, statementNum, this.idGenerator.next(), scriptTxContext, params, nextCursorFuture);
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        try {
            this.trackQuery(query, null);
        }
        finally {
            this.busyLock.leaveBusy();
        }
        try {
            parent.cancel.attach(query.cancel);
        }
        catch (QueryCancelledException ex2) {
            query.moveTo(ExecutionPhase.TERMINATED);
            return CompletableFuture.failedFuture((Throwable)((Object)ex2));
        }
        return Programs.SCRIPT_ITEM_EXECUTION.run(query).whenComplete((cursor, ex) -> {
            if (cursor != null) {
                cursor.onClose().thenRun(() -> query.moveTo(ExecutionPhase.TERMINATED));
            }
        });
    }

    @Nullable
    public ParsedResult lookupParsedResultInCache(String sql) {
        return this.queryToParsedResultCache.get(sql);
    }

    public void updateParsedResultCache(String sql, ParsedResult result) {
        this.queryToParsedResultCache.put(sql, result);
    }

    public ParsedResult parse(String sql) {
        return this.parserService.parse(sql);
    }

    List<ParsedResult> parseScript(String sql) {
        return this.parserService.parseScript(sql);
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    HybridTimestamp deriveOperationTime(QueryTransactionContext txContext) {
        QueryTransactionWrapper txWrapper = txContext.explicitTx();
        if (txWrapper == null) {
            return this.clockService.now();
        }
        return txWrapper.unwrap().startTimestamp();
    }

    CompletableFuture<Void> waitForMetadata(HybridTimestamp timestamp) {
        return this.schemaSyncService.waitForMetadataCompleteness(timestamp);
    }

    CompletableFuture<QueryPlan> prepare(ParsedResult result, SqlOperationContext operationContext) {
        return this.prepareService.prepareAsync(result, operationContext);
    }

    HybridTimestamp deriveMinimalRequiredTime(QueryPlan plan) {
        Integer catalogVersion = null;
        if (plan instanceof MultiStepPlan) {
            catalogVersion = ((MultiStepPlan)plan).catalogVersion();
        } else if (plan instanceof KeyValueModifyPlan) {
            catalogVersion = ((KeyValueModifyPlan)plan).catalogVersion();
        } else if (plan instanceof KeyValueGetPlan) {
            catalogVersion = ((KeyValueGetPlan)plan).catalogVersion();
        }
        if (catalogVersion != null) {
            Catalog catalog = this.catalogService.catalog(catalogVersion.intValue());
            assert (catalog != null);
            return HybridTimestamp.hybridTimestamp((long)catalog.time());
        }
        return this.clockService.now();
    }

    CompletableFuture<AsyncDataCursorExt<InternalSqlRow>> executePlan(SqlOperationContext ctx, QueryPlan plan) {
        return this.executionService.executePlan(plan, ctx);
    }

    HybridTimestamp clockNow() {
        return this.clockService.now();
    }

    MultiStatementHandler createScriptHandler(Query query) {
        List<ParsedResult> parsedResults = query.parsedScript;
        assert (parsedResults != null);
        return new MultiStatementHandler(this.transactionTracker, query, query.txContext, parsedResults, query.params);
    }

    private void trackQuery(Query query, @Nullable CancellationToken cancellationToken) {
        Query old = this.runningQueries.put(query.id, query);
        this.eventLog.log(IgniteEventType.QUERY_STARTED.name(), () -> this.eventsFactory.makeStartEvent(new QueryInfo(query), EventUser.system()));
        assert (old == null) : "Query with the same id already registered";
        CompletableFuture<Void> queryTerminationFut = query.onPhaseStarted(ExecutionPhase.TERMINATED);
        queryTerminationFut.whenComplete((none, ignoredEx) -> {
            this.runningQueries.remove(query.id);
            long finishTime = this.clockService.current().getPhysical();
            this.eventLog.log(IgniteEventType.QUERY_FINISHED.name(), () -> this.eventsFactory.makeFinishEvent(new QueryInfo(query), EventUser.system(), finishTime));
        });
        if (cancellationToken != null) {
            CancelHandleHelper.addCancelAction((CancellationToken)cancellationToken, query::cancel, queryTerminationFut);
        }
    }

    public List<QueryInfo> runningQueries() {
        return this.runningQueries.values().stream().map(QueryInfo::new).collect(Collectors.toList());
    }

    public CompletableFuture<Boolean> cancelQuery(UUID queryId) {
        Query query = (Query)this.runningQueries.get(queryId);
        if (query == null) {
            return CompletableFutures.falseCompletedFuture();
        }
        return query.cancel().thenApply(none -> Boolean.TRUE);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() throws Exception {
        this.busyLock.block();
        NodeStoppingException ex = new NodeStoppingException();
        this.runningQueries.values().forEach(arg_0 -> QueryExecutor.lambda$stop$8((Exception)ex, arg_0));
    }

    private static /* synthetic */ void lambda$stop$8(Exception ex, Query query) {
        query.onError(ex);
    }
}

