/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelMultipleTrait;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.trait.DistributionFunction;
import org.apache.ignite.internal.sql.engine.trait.DistributionTraitDef;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;

public final class DistributionTrait
implements IgniteDistribution {
    private static final Comparator<Iterable<Integer>> ORDERING = (iterable0, iterable1) -> {
        Iterator it0 = iterable0.iterator();
        Iterator it1 = iterable1.iterator();
        while (it0.hasNext()) {
            if (!it1.hasNext()) {
                return 1;
            }
            int result = Integer.compare((Integer)it0.next(), (Integer)it1.next());
            if (result == 0) continue;
            return result;
        }
        if (it1.hasNext()) {
            return -1;
        }
        return 0;
    };
    private final DistributionFunction function;
    private final ImmutableIntList keys;

    DistributionTrait(DistributionFunction function) {
        assert (function.type() != RelDistribution.Type.HASH_DISTRIBUTED);
        this.function = function;
        this.keys = ImmutableIntList.of();
    }

    DistributionTrait(List<Integer> keys, DistributionFunction function) {
        this.keys = ImmutableIntList.copyOf(keys);
        this.function = function;
    }

    public RelDistribution.Type getType() {
        return this.function.type();
    }

    @Override
    public DistributionFunction function() {
        return this.function;
    }

    @Override
    public ImmutableIntList getKeys() {
        return this.keys;
    }

    public void register(RelOptPlanner planner) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DistributionTrait) {
            DistributionTrait that = (DistributionTrait)o;
            return Objects.equals(this.function, that.function) && Objects.equals(this.keys, that.keys);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.function, this.keys);
    }

    public String toString() {
        return this.function.name() + String.valueOf(this.function.type() == RelDistribution.Type.HASH_DISTRIBUTED ? this.keys : "");
    }

    public DistributionTraitDef getTraitDef() {
        return DistributionTraitDef.INSTANCE;
    }

    public boolean satisfies(RelTrait trait) {
        if (trait == this) {
            return true;
        }
        if (!(trait instanceof DistributionTrait)) {
            return false;
        }
        DistributionTrait other = (DistributionTrait)trait;
        if (other.getType() == RelDistribution.Type.ANY) {
            return true;
        }
        if (this.getType() == other.getType()) {
            return this.getType() != RelDistribution.Type.HASH_DISTRIBUTED || Objects.equals(this.keys, other.keys) && DistributionFunction.satisfy(this.function, other.function);
        }
        if (other.getType() == RelDistribution.Type.RANDOM_DISTRIBUTED) {
            return this.getType() == RelDistribution.Type.HASH_DISTRIBUTED;
        }
        return other.getType() == RelDistribution.Type.SINGLETON && this.getType() == RelDistribution.Type.BROADCAST_DISTRIBUTED;
    }

    @Override
    public IgniteDistribution apply(Mappings.TargetMapping mapping) {
        if (this.getType() != RelDistribution.Type.HASH_DISTRIBUTED) {
            return this;
        }
        Iterator iterator = this.keys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            if (mapping.getTargetOpt(key) != -1) continue;
            return IgniteDistributions.random();
        }
        List res = Mappings.apply2((Mapping)((Mapping)mapping), (List)this.keys);
        return IgniteDistributions.hash((List<Integer>)ImmutableIntList.copyOf((Iterable)res), this.function);
    }

    public boolean isTop() {
        return this.getType() == RelDistribution.Type.ANY;
    }

    public int compareTo(RelMultipleTrait o) {
        IgniteDistribution distribution = (IgniteDistribution)o;
        if (this.getType() == distribution.getType() && this.getType() == RelDistribution.Type.HASH_DISTRIBUTED) {
            int cmp = ORDERING.compare((Iterable<Integer>)this.getKeys(), (Iterable<Integer>)distribution.getKeys());
            if (cmp == 0) {
                cmp = this.function.name().compareTo(distribution.function().name());
            }
            return cmp;
        }
        return this.getType().compareTo((Enum)distribution.getType());
    }
}

