/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters.otlp;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.PrimitiveLongList;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.metrics.DistributionMetric;
import org.apache.ignite.internal.metrics.exporters.otlp.IgniteMetricData;
import org.apache.ignite.internal.metrics.exporters.otlp.IgnitePointData;
import org.apache.ignite.internal.util.Lazy;

class IgniteDistributionMetricData
extends IgniteMetricData<DistributionMetric> {
    private final HistogramData data;

    IgniteDistributionMetricData(Lazy<Resource> resource, InstrumentationScopeInfo scope, DistributionMetric metric) {
        super(resource, scope, metric);
        this.data = new IgniteHistogramData(new IgniteDistributionPointData(metric));
    }

    public MetricDataType getType() {
        return MetricDataType.HISTOGRAM;
    }

    public Data<?> getData() {
        return this.data;
    }

    static class IgniteHistogramData
    implements HistogramData {
        private final Collection<HistogramPointData> points;

        IgniteHistogramData(HistogramPointData data) {
            this.points = Collections.singletonList(data);
        }

        public AggregationTemporality getAggregationTemporality() {
            return AggregationTemporality.CUMULATIVE;
        }

        public Collection<HistogramPointData> getPoints() {
            return this.points;
        }
    }

    static class IgniteDistributionPointData
    extends IgnitePointData
    implements HistogramPointData {
        private final DistributionMetric metric;
        private final List<Double> boundaries;

        IgniteDistributionPointData(DistributionMetric metric) {
            this.metric = metric;
            this.boundaries = IgniteDistributionPointData.asDoubleList(metric.bounds());
        }

        public double getSum() {
            return Double.NaN;
        }

        public long getCount() {
            long totalCount = 0L;
            for (long c : this.metric.value()) {
                totalCount += c;
            }
            return totalCount;
        }

        public boolean hasMin() {
            return false;
        }

        public double getMin() {
            return Double.NaN;
        }

        public boolean hasMax() {
            return false;
        }

        public double getMax() {
            return Double.NaN;
        }

        public List<Double> getBoundaries() {
            return this.boundaries;
        }

        public List<Long> getCounts() {
            return PrimitiveLongList.wrap((long[])this.metric.value());
        }

        public List<DoubleExemplarData> getExemplars() {
            return Collections.emptyList();
        }

        private static List<Double> asDoubleList(long[] array) {
            ArrayList<Double> result = new ArrayList<Double>(array.length);
            for (long el : array) {
                result.add(Double.valueOf(el));
            }
            return result;
        }
    }
}

