/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.compute.NextWorkerSelector;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

public class NextColocatedWorkerSelector<K>
implements NextWorkerSelector {
    private static final int PRIMARY_REPLICA_ASK_CLOCK_ADDITION_MILLIS = 10000;
    private static final int AWAIT_FOR_PRIMARY_REPLICA_SECONDS = 15;
    private final PlacementDriver placementDriver;
    private final TopologyService topologyService;
    private final HybridClock clock;
    @Nullable
    private final K key;
    @Nullable
    private final Mapper<K> keyMapper;
    private final Tuple tuple;
    private final TableViewInternal table;

    NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, TableViewInternal table, K key, Mapper<K> keyMapper) {
        this(placementDriver, topologyService, clock, table, key, keyMapper, null);
    }

    NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, TableViewInternal table, Tuple tuple) {
        this(placementDriver, topologyService, clock, table, null, null, tuple);
    }

    private NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, TableViewInternal table, @Nullable K key, @Nullable Mapper<K> keyMapper, @Nullable Tuple tuple) {
        this.placementDriver = placementDriver;
        this.topologyService = topologyService;
        this.table = table;
        this.clock = clock;
        this.key = key;
        this.keyMapper = keyMapper;
        this.tuple = tuple;
    }

    private CompletableFuture<ClusterNode> tryToFindPrimaryReplica(TablePartitionId tablePartitionId) {
        return ((CompletableFuture)this.placementDriver.awaitPrimaryReplica((ReplicationGroupId)tablePartitionId, this.clock.now().addPhysicalTime(10000L), 15L, TimeUnit.SECONDS).thenApply(ReplicaMeta::getLeaseholderId)).thenApply(arg_0 -> ((TopologyService)this.topologyService).getById(arg_0));
    }

    @Override
    public CompletableFuture<ClusterNode> next() {
        TablePartitionId tablePartitionId = this.tablePartitionId();
        return this.tryToFindPrimaryReplica(tablePartitionId);
    }

    private TablePartitionId tablePartitionId() {
        if (this.key != null && this.keyMapper != null) {
            return new TablePartitionId(this.table.tableId(), this.table.partitionId(this.key, this.keyMapper));
        }
        return new TablePartitionId(this.table.tableId(), this.table.partitionId(this.tuple));
    }
}

