/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute;

public class JobExecutionOptions {
    public static final JobExecutionOptions DEFAULT = JobExecutionOptions.builder().priority(0).maxRetries(0).build();
    private final int priority;
    private final int maxRetries;

    private JobExecutionOptions(int priority, int maxRetries) {
        this.priority = priority;
        this.maxRetries = maxRetries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int priority() {
        return this.priority;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public static class Builder {
        private int priority;
        private int maxRetries;

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public JobExecutionOptions build() {
            return new JobExecutionOptions(this.priority, this.maxRetries);
        }
    }
}

