/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.schema.ColumnsExtractor;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageDestroyedException;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.index.PeekCursor;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.table.distributed.IndexLocker;
import org.apache.ignite.internal.tx.Lock;
import org.apache.ignite.internal.tx.LockKey;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.LockMode;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class SortedIndexLocker
implements IndexLocker {
    private final Object positiveInf;
    private final int indexId;
    private final LockManager lockManager;
    private final boolean unique;
    private final SortedIndexStorage storage;
    private final ColumnsExtractor indexRowResolver;

    public SortedIndexLocker(int indexId, int partId, LockManager lockManager, SortedIndexStorage storage, ColumnsExtractor indexRowResolver, boolean unique) {
        this.indexId = indexId;
        this.lockManager = lockManager;
        this.storage = storage;
        this.indexRowResolver = indexRowResolver;
        this.positiveInf = partId;
        this.unique = unique;
    }

    @Override
    public int id() {
        return this.indexId;
    }

    @Override
    public CompletableFuture<Void> locksForLookupByKey(UUID txId, BinaryTuple key) {
        return this.lockManager.acquire(txId, new LockKey((Object)this.indexId, (Object)key.byteBuffer()), LockMode.S).thenApply(lock -> null);
    }

    @Override
    public CompletableFuture<Void> locksForLookup(UUID txId, BinaryRow tableRow) {
        BinaryTuple key = this.indexRowResolver.extractColumns(tableRow);
        return this.locksForLookupByKey(txId, key);
    }

    public CompletableFuture<IndexRow> locksForScan(UUID txId, Cursor<IndexRow> cursor) {
        assert (cursor instanceof PeekCursor) : "Cursor has incorrect type [type=" + cursor.getClass().getSimpleName() + "]";
        PeekCursor peekCursor = (PeekCursor)cursor;
        return this.acquireLockNextKey(txId, (PeekCursor<IndexRow>)peekCursor).thenApply(indexRow -> {
            if (indexRow == null) {
                return null;
            }
            return (IndexRow)peekCursor.next();
        });
    }

    private CompletableFuture<IndexRow> acquireLockNextKey(UUID txId, PeekCursor<IndexRow> peekCursor) {
        IndexRow peekedRow = (IndexRow)peekCursor.peek();
        LockKey lockKey = new LockKey((Object)this.indexId, this.indexKey(peekedRow));
        return this.lockManager.acquire(txId, lockKey, LockMode.S).thenCompose(ignore -> {
            IndexRow peekedRowAfterLock = (IndexRow)peekCursor.peek();
            if (!SortedIndexLocker.rowIdMatches(peekedRow, peekedRowAfterLock)) {
                this.lockManager.release(txId, lockKey, LockMode.S);
                return this.acquireLockNextKey(txId, peekCursor);
            }
            return CompletableFuture.completedFuture(peekedRow);
        });
    }

    private static boolean rowIdMatches(@Nullable IndexRow row0, @Nullable IndexRow row1) {
        if (row0 == null ^ row1 == null) {
            return false;
        }
        return row0 == row1 || row0.rowId().equals((Object)row1.rowId());
    }

    private Object indexKey(@Nullable IndexRow indexRow) {
        return indexRow == null ? this.positiveInf : indexRow.indexColumns().byteBuffer();
    }

    @Override
    public CompletableFuture<@Nullable Lock> locksForInsert(UUID txId, BinaryRow tableRow, RowId rowId) {
        BinaryTuple key = this.indexRowResolver.extractColumns(tableRow);
        BinaryTuplePrefix prefix = BinaryTuplePrefix.fromBinaryTuple((BinaryTuple)key);
        IndexRow nextRow = null;
        try (PeekCursor cursor = this.storage.tolerantScan(prefix, null, 0);){
            if (cursor.hasNext()) {
                nextRow = (IndexRow)cursor.next();
            }
        }
        catch (StorageDestroyedException ignored) {
            return CompletableFutures.nullCompletedFuture();
        }
        LockKey nextLockKey = new LockKey((Object)this.indexId, this.indexKey(nextRow));
        return this.lockManager.acquire(txId, nextLockKey, LockMode.IX).thenCompose(shortLock -> {
            LockMode modeToLock = this.currentKeyLockMode(shortLock.lockMode());
            return this.lockManager.acquire(txId, new LockKey((Object)this.indexId, (Object)key.byteBuffer()), modeToLock).thenApply(lock -> new Lock(nextLockKey, LockMode.IX, txId));
        });
    }

    private LockMode currentKeyLockMode(LockMode nextKeyLockMode) {
        if (this.unique) {
            return LockMode.X;
        }
        if (nextKeyLockMode == LockMode.S || nextKeyLockMode == LockMode.X || nextKeyLockMode == LockMode.SIX) {
            return LockMode.X;
        }
        return LockMode.IX;
    }

    @Override
    public CompletableFuture<Void> locksForRemove(UUID txId, BinaryRow tableRow, RowId rowId) {
        BinaryTuple key = this.indexRowResolver.extractColumns(tableRow);
        return this.lockManager.acquire(txId, new LockKey((Object)this.indexId, (Object)key.byteBuffer()), LockMode.IX).thenApply(lock -> null);
    }
}

