/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocolPB;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.CancelDelegationTokenRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.CancelDelegationTokenResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.FailTaskAttemptRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.FailTaskAttemptResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetCountersRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetCountersResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetDelegationTokenRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetDelegationTokenResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetDiagnosticsRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetDiagnosticsResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetJobReportRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetJobReportResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetTaskAttemptCompletionEventsRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetTaskAttemptCompletionEventsResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetTaskAttemptReportRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetTaskAttemptReportResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetTaskReportRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetTaskReportResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetTaskReportsRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.GetTaskReportsResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.KillJobRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.KillJobResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.KillTaskAttemptRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.KillTaskAttemptResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.KillTaskRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.KillTaskResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.RenewDelegationTokenRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.RenewDelegationTokenResponsePBImpl;
import org.apache.hadoop.mapreduce.v2.proto.MRServiceProtos;
import org.apache.hadoop.security.proto.SecurityProtos;

public class MRClientProtocolPBClientImpl
implements MRClientProtocol,
Closeable {
    protected MRClientProtocolPB proxy;

    public MRClientProtocolPBClientImpl() {
    }

    public MRClientProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, MRClientProtocolPB.class, ProtobufRpcEngine.class);
        this.proxy = (MRClientProtocolPB)RPC.getProxy(MRClientProtocolPB.class, (long)clientVersion, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Override
    public InetSocketAddress getConnectAddress() {
        return RPC.getServerAddress((Object)this.proxy);
    }

    @Override
    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }

    @Override
    public GetJobReportResponse getJobReport(GetJobReportRequest request) throws IOException {
        MRServiceProtos.GetJobReportRequestProto requestProto = ((GetJobReportRequestPBImpl)request).getProto();
        try {
            return new GetJobReportResponsePBImpl(this.proxy.getJobReport(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public GetTaskReportResponse getTaskReport(GetTaskReportRequest request) throws IOException {
        MRServiceProtos.GetTaskReportRequestProto requestProto = ((GetTaskReportRequestPBImpl)request).getProto();
        try {
            return new GetTaskReportResponsePBImpl(this.proxy.getTaskReport(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public GetTaskAttemptReportResponse getTaskAttemptReport(GetTaskAttemptReportRequest request) throws IOException {
        MRServiceProtos.GetTaskAttemptReportRequestProto requestProto = ((GetTaskAttemptReportRequestPBImpl)request).getProto();
        try {
            return new GetTaskAttemptReportResponsePBImpl(this.proxy.getTaskAttemptReport(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public GetCountersResponse getCounters(GetCountersRequest request) throws IOException {
        MRServiceProtos.GetCountersRequestProto requestProto = ((GetCountersRequestPBImpl)request).getProto();
        try {
            return new GetCountersResponsePBImpl(this.proxy.getCounters(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public GetTaskAttemptCompletionEventsResponse getTaskAttemptCompletionEvents(GetTaskAttemptCompletionEventsRequest request) throws IOException {
        MRServiceProtos.GetTaskAttemptCompletionEventsRequestProto requestProto = ((GetTaskAttemptCompletionEventsRequestPBImpl)request).getProto();
        try {
            return new GetTaskAttemptCompletionEventsResponsePBImpl(this.proxy.getTaskAttemptCompletionEvents(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public GetTaskReportsResponse getTaskReports(GetTaskReportsRequest request) throws IOException {
        MRServiceProtos.GetTaskReportsRequestProto requestProto = ((GetTaskReportsRequestPBImpl)request).getProto();
        try {
            return new GetTaskReportsResponsePBImpl(this.proxy.getTaskReports(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public GetDiagnosticsResponse getDiagnostics(GetDiagnosticsRequest request) throws IOException {
        MRServiceProtos.GetDiagnosticsRequestProto requestProto = ((GetDiagnosticsRequestPBImpl)request).getProto();
        try {
            return new GetDiagnosticsResponsePBImpl(this.proxy.getDiagnostics(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws IOException {
        SecurityProtos.GetDelegationTokenRequestProto requestProto = ((GetDelegationTokenRequestPBImpl)request).getProto();
        try {
            return new GetDelegationTokenResponsePBImpl(this.proxy.getDelegationToken(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public KillJobResponse killJob(KillJobRequest request) throws IOException {
        MRServiceProtos.KillJobRequestProto requestProto = ((KillJobRequestPBImpl)request).getProto();
        try {
            return new KillJobResponsePBImpl(this.proxy.killJob(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public KillTaskResponse killTask(KillTaskRequest request) throws IOException {
        MRServiceProtos.KillTaskRequestProto requestProto = ((KillTaskRequestPBImpl)request).getProto();
        try {
            return new KillTaskResponsePBImpl(this.proxy.killTask(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public KillTaskAttemptResponse killTaskAttempt(KillTaskAttemptRequest request) throws IOException {
        MRServiceProtos.KillTaskAttemptRequestProto requestProto = ((KillTaskAttemptRequestPBImpl)request).getProto();
        try {
            return new KillTaskAttemptResponsePBImpl(this.proxy.killTaskAttempt(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public FailTaskAttemptResponse failTaskAttempt(FailTaskAttemptRequest request) throws IOException {
        MRServiceProtos.FailTaskAttemptRequestProto requestProto = ((FailTaskAttemptRequestPBImpl)request).getProto();
        try {
            return new FailTaskAttemptResponsePBImpl(this.proxy.failTaskAttempt(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws IOException {
        SecurityProtos.RenewDelegationTokenRequestProto requestProto = ((RenewDelegationTokenRequestPBImpl)request).getProto();
        try {
            return new RenewDelegationTokenResponsePBImpl(this.proxy.renewDelegationToken(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    @Override
    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws IOException {
        SecurityProtos.CancelDelegationTokenRequestProto requestProto = ((CancelDelegationTokenRequestPBImpl)request).getProto();
        try {
            return new CancelDelegationTokenResponsePBImpl(this.proxy.cancelDelegationToken(null, requestProto));
        }
        catch (ServiceException e) {
            throw this.unwrapAndThrowException(e);
        }
    }

    private IOException unwrapAndThrowException(ServiceException se) {
        if (se.getCause() instanceof RemoteException) {
            return ((RemoteException)se.getCause()).unwrapRemoteException();
        }
        if (se.getCause() instanceof IOException) {
            return (IOException)se.getCause();
        }
        throw new UndeclaredThrowableException(se.getCause());
    }
}

