/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.livy.client.common.ClientConf;

public class RSCConf
extends ClientConf<RSCConf> {
    public static final String SPARK_CONF_PREFIX = "spark.";
    public static final String LIVY_SPARK_PREFIX = "spark.__livy__.";
    private static final String RSC_CONF_PREFIX = "livy.rsc.";
    private static final Map<String, ClientConf.DeprecatedConf> configsWithAlternatives = Collections.unmodifiableMap(new HashMap<String, ClientConf.DeprecatedConf>(){
        {
            this.put(Entry.CLIENT_IN_PROCESS.key, DepConf.CLIENT_IN_PROCESS);
            this.put(Entry.CLIENT_SHUTDOWN_TIMEOUT.key, DepConf.CLIENT_SHUTDOWN_TIMEOUT);
            this.put(Entry.DRIVER_CLASS.key, DepConf.DRIVER_CLASS);
            this.put(Entry.SERVER_IDLE_TIMEOUT.key, DepConf.SERVER_IDLE_TIMEOUT);
            this.put(Entry.PROXY_USER.key, DepConf.PROXY_USER);
            this.put(Entry.TEST_STUCK_END_SESSION.key, DepConf.TEST_STUCK_END_SESSION);
            this.put(Entry.TEST_STUCK_START_DRIVER.key, DepConf.TEST_STUCK_START_DRIVER);
            this.put(Entry.JOB_CANCEL_TRIGGER_INTERVAL.key, DepConf.JOB_CANCEL_TRIGGER_INTERVAL);
            this.put(Entry.JOB_CANCEL_TIMEOUT.key, DepConf.JOB_CANCEL_TIMEOUT);
            this.put(Entry.RETAINED_STATEMENT_NUMBER.key, DepConf.RETAINED_STATEMENT_NUMBER);
        }
    });
    private static final Map<String, ClientConf.DeprecatedConf> deprecatedConfigs = Collections.unmodifiableMap(new HashMap());

    public RSCConf() {
        this(new Properties());
    }

    public RSCConf(Properties config) {
        super(config);
    }

    public Map<String, String> getSaslOptions() {
        HashMap<String, String> opts = new HashMap<String, String>();
        String qop = this.get(Entry.SASL_QOP);
        if (qop != null) {
            opts.put("javax.security.sasl.qop", qop);
        }
        return opts;
    }

    public String findLocalAddress() throws IOException {
        InetAddress address = InetAddress.getLocalHost();
        if (address.isLoopbackAddress()) {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface ni = ifaces.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (addr.isLinkLocalAddress() || addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    this.LOG.warn("Your hostname, {}, resolves to a loopback address; using {}  instead (on interface {})", new Object[]{address.getHostName(), addr.getHostAddress(), ni.getName()});
                    this.LOG.warn("Set '{}' if you need to bind to another address.", (Object)Entry.RPC_SERVER_ADDRESS.key);
                    return addr.getHostAddress();
                }
            }
        }
        this.LOG.warn("Your hostname, {}, resolves to a loopback address, but we couldn't find any external IP address!", (Object)address.getCanonicalHostName());
        this.LOG.warn("Set {} if you need to bind to another address.", (Object)Entry.RPC_SERVER_ADDRESS.key);
        return address.getCanonicalHostName();
    }

    @Override
    protected Map<String, ClientConf.DeprecatedConf> getConfigsWithAlternatives() {
        return configsWithAlternatives;
    }

    @Override
    protected Map<String, ClientConf.DeprecatedConf> getDeprecatedConfigs() {
        return deprecatedConfigs;
    }

    static enum DepConf implements ClientConf.DeprecatedConf
    {
        CLIENT_IN_PROCESS("client.do_not_use.run_driver_in_process", "0.4"),
        CLIENT_SHUTDOWN_TIMEOUT("client.shutdown_timeout", "0.4"),
        DRIVER_CLASS("driver_class", "0.4"),
        SERVER_IDLE_TIMEOUT("server.idle_timeout", "0.4"),
        PROXY_USER("proxy_user", "0.4"),
        TEST_STUCK_END_SESSION("test.do_not_use.stuck_end_session", "0.4"),
        TEST_STUCK_START_DRIVER("test.do_not_use.stuck_start_driver", "0.4"),
        JOB_CANCEL_TRIGGER_INTERVAL("job_cancel.trigger_interval", "0.4"),
        JOB_CANCEL_TIMEOUT("job_cancel.timeout", "0.4"),
        RETAINED_STATEMENT_NUMBER("retained_statements", "0.4");

        private final String key;
        private final String version;
        private final String deprecationMessage;

        private DepConf(String key, String version) {
            this(key, version, "");
        }

        private DepConf(String key, String version, String deprecationMessage) {
            this.key = RSCConf.RSC_CONF_PREFIX + key;
            this.version = version;
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public String deprecationMessage() {
            return this.deprecationMessage;
        }
    }

    public static enum Entry implements ClientConf.ConfEntry
    {
        CLIENT_ID("client.auth.id", null),
        CLIENT_SECRET("client.auth.secret", null),
        CLIENT_IN_PROCESS("client.do-not-use.run-driver-in-process", false),
        CLIENT_SHUTDOWN_TIMEOUT("client.shutdown-timeout", "10s"),
        DRIVER_CLASS("driver-class", null),
        SESSION_KIND("session.kind", null),
        LIVY_JARS("jars", null),
        SPARKR_PACKAGE("sparkr.package", null),
        PYSPARK_ARCHIVES("pyspark.archives", null),
        LAUNCHER_ADDRESS("launcher.address", null),
        LAUNCHER_PORT_RANGE("launcher.port.range", "10000~10010"),
        LAUNCHER_PORT("launcher.port", -1),
        SERVER_IDLE_TIMEOUT("server.idle-timeout", "10m"),
        PROXY_USER("proxy-user", null),
        RPC_SERVER_ADDRESS("rpc.server.address", null),
        RPC_CLIENT_HANDSHAKE_TIMEOUT("server.connect.timeout", "90s"),
        RPC_CLIENT_CONNECT_TIMEOUT("client.connect.timeout", "10s"),
        RPC_CHANNEL_LOG_LEVEL("channel.log.level", null),
        RPC_MAX_MESSAGE_SIZE("rpc.max.size", 0x3200000),
        RPC_MAX_THREADS("rpc.threads", 8),
        RPC_SECRET_RANDOM_BITS("secret.bits", 256),
        SASL_MECHANISMS("rpc.sasl.mechanisms", "DIGEST-MD5"),
        SASL_QOP("rpc.sasl.qop", null),
        TEST_STUCK_END_SESSION("test.do-not-use.stuck-end-session", false),
        TEST_STUCK_START_DRIVER("test.do-not-use.stuck-start-driver", false),
        JOB_CANCEL_TRIGGER_INTERVAL("job-cancel.trigger-interval", "100ms"),
        JOB_CANCEL_TIMEOUT("job-cancel.timeout", "30s"),
        RETAINED_STATEMENT_NUMBER("retained-statements", 100);

        private final String key;
        private final Object dflt;

        private Entry(String key, Object dflt) {
            this.key = RSCConf.RSC_CONF_PREFIX + key;
            this.dflt = dflt;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Object dflt() {
            return this.dflt;
        }
    }
}

