/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.ProgressSplitsBlock;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.AvroArrayUtils;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletion;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptUnsuccessfulCompletionEvent
implements HistoryEvent {
    private TaskAttemptUnsuccessfulCompletion datum = null;
    private TaskAttemptID attemptId;
    private TaskType taskType;
    private String status;
    private long finishTime;
    private String hostname;
    private int port;
    private String rackName;
    private String error;
    private Counters counters;
    int[][] allSplits;
    int[] clockSplits;
    int[] cpuUsages;
    int[] vMemKbytes;
    int[] physMemKbytes;
    private static final Counters EMPTY_COUNTERS = new Counters();

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, int port, String rackName, String error, Counters counters, int[][] allSplits) {
        this.attemptId = id;
        this.taskType = taskType;
        this.status = status;
        this.finishTime = finishTime;
        this.hostname = hostname;
        this.port = port;
        this.rackName = rackName;
        this.error = error;
        this.counters = counters;
        this.allSplits = allSplits;
        this.clockSplits = ProgressSplitsBlock.arrayGetWallclockTime(allSplits);
        this.cpuUsages = ProgressSplitsBlock.arrayGetCPUTime(allSplits);
        this.vMemKbytes = ProgressSplitsBlock.arrayGetVMemKbytes(allSplits);
        this.physMemKbytes = ProgressSplitsBlock.arrayGetPhysMemKbytes(allSplits);
    }

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, String error) {
        this(id, taskType, status, finishTime, hostname, -1, "", error, EMPTY_COUNTERS, null);
    }

    public TaskAttemptUnsuccessfulCompletionEvent(TaskAttemptID id, TaskType taskType, String status, long finishTime, String hostname, int port, String rackName, String error, int[][] allSplits) {
        this(id, taskType, status, finishTime, hostname, port, rackName, error, EMPTY_COUNTERS, null);
    }

    TaskAttemptUnsuccessfulCompletionEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new TaskAttemptUnsuccessfulCompletion();
            this.datum.taskid = new Utf8(this.attemptId.getTaskID().toString());
            this.datum.taskType = new Utf8(this.taskType.name());
            this.datum.attemptId = new Utf8(this.attemptId.toString());
            this.datum.finishTime = this.finishTime;
            this.datum.hostname = new Utf8(this.hostname);
            if (this.rackName != null) {
                this.datum.rackname = new Utf8(this.rackName);
            }
            this.datum.port = this.port;
            this.datum.error = new Utf8(this.error);
            this.datum.status = new Utf8(this.status);
            this.datum.counters = EventWriter.toAvro(this.counters);
            this.datum.clockSplits = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetWallclockTime(this.allSplits));
            this.datum.cpuUsages = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetCPUTime(this.allSplits));
            this.datum.vMemKbytes = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetVMemKbytes(this.allSplits));
            this.datum.physMemKbytes = AvroArrayUtils.toAvro(ProgressSplitsBlock.arrayGetPhysMemKbytes(this.allSplits));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object odatum) {
        this.datum = (TaskAttemptUnsuccessfulCompletion)((Object)odatum);
        this.attemptId = TaskAttemptID.forName(this.datum.attemptId.toString());
        this.taskType = TaskType.valueOf(this.datum.taskType.toString());
        this.finishTime = this.datum.finishTime;
        this.hostname = this.datum.hostname.toString();
        this.rackName = this.datum.rackname.toString();
        this.port = this.datum.port;
        this.status = this.datum.status.toString();
        this.error = this.datum.error.toString();
        this.counters = EventReader.fromAvro(this.datum.counters);
        this.clockSplits = AvroArrayUtils.fromAvro(this.datum.clockSplits);
        this.cpuUsages = AvroArrayUtils.fromAvro(this.datum.cpuUsages);
        this.vMemKbytes = AvroArrayUtils.fromAvro(this.datum.vMemKbytes);
        this.physMemKbytes = AvroArrayUtils.fromAvro(this.datum.physMemKbytes);
    }

    public TaskID getTaskId() {
        return this.attemptId.getTaskID();
    }

    public TaskType getTaskType() {
        return TaskType.valueOf(this.taskType.toString());
    }

    public TaskAttemptID getTaskAttemptId() {
        return this.attemptId;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getRackName() {
        return this.rackName == null ? null : this.rackName.toString();
    }

    public String getError() {
        return this.error.toString();
    }

    public String getTaskStatus() {
        return this.status.toString();
    }

    Counters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        boolean failed = TaskStatus.State.FAILED.toString().equals(this.getTaskStatus());
        return this.getTaskId().getTaskType() == TaskType.MAP ? (failed ? EventType.MAP_ATTEMPT_FAILED : EventType.MAP_ATTEMPT_KILLED) : (failed ? EventType.REDUCE_ATTEMPT_FAILED : EventType.REDUCE_ATTEMPT_KILLED);
    }

    public int[] getClockSplits() {
        return this.clockSplits;
    }

    public int[] getCpuUsages() {
        return this.cpuUsages;
    }

    public int[] getVMemKbytes() {
        return this.vMemKbytes;
    }

    public int[] getPhysMemKbytes() {
        return this.physMemKbytes;
    }
}

