/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CompressionCodecFactory {
    public static final Log LOG = LogFactory.getLog((String)CompressionCodecFactory.class.getName());
    private static final ServiceLoader<CompressionCodec> CODEC_PROVIDERS = ServiceLoader.load(CompressionCodec.class);
    private SortedMap<String, CompressionCodec> codecs = new TreeMap<String, CompressionCodec>();
    private Map<String, CompressionCodec> codecsByName = null;
    private HashMap<String, CompressionCodec> codecsByClassName = new HashMap();

    private void addCodec(CompressionCodec codec) {
        String suffix = codec.getDefaultExtension();
        this.codecs.put(new StringBuilder(suffix).reverse().toString(), codec);
        this.codecsByClassName.put(codec.getClass().getCanonicalName(), codec);
        String codecName = codec.getClass().getSimpleName();
        this.codecsByName.put(StringUtils.toLowerCase(codecName), codec);
        if (codecName.endsWith("Codec")) {
            codecName = codecName.substring(0, codecName.length() - "Codec".length());
            this.codecsByName.put(StringUtils.toLowerCase(codecName), codec);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Iterator<Map.Entry<String, CompressionCodec>> itr = this.codecs.entrySet().iterator();
        buf.append("{ ");
        if (itr.hasNext()) {
            Map.Entry<String, CompressionCodec> entry = itr.next();
            buf.append(entry.getKey());
            buf.append(": ");
            buf.append(entry.getValue().getClass().getName());
            while (itr.hasNext()) {
                entry = itr.next();
                buf.append(", ");
                buf.append(entry.getKey());
                buf.append(": ");
                buf.append(entry.getValue().getClass().getName());
            }
        }
        buf.append(" }");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<? extends CompressionCodec>> getCodecClasses(Configuration conf) {
        ArrayList<Class<? extends CompressionCodec>> result = new ArrayList<Class<? extends CompressionCodec>>();
        ServiceLoader<CompressionCodec> serviceLoader = CODEC_PROVIDERS;
        synchronized (serviceLoader) {
            for (CompressionCodec codec : CODEC_PROVIDERS) {
                result.add(codec.getClass());
            }
        }
        String codecsString = conf.get("io.compression.codecs");
        if (codecsString != null) {
            StringTokenizer codecSplit = new StringTokenizer(codecsString, ",");
            while (codecSplit.hasMoreElements()) {
                String codecSubstring = codecSplit.nextToken().trim();
                if (codecSubstring.length() == 0) continue;
                try {
                    Class<?> cls = conf.getClassByName(codecSubstring);
                    if (!CompressionCodec.class.isAssignableFrom(cls)) {
                        throw new IllegalArgumentException("Class " + codecSubstring + " is not a CompressionCodec");
                    }
                    result.add(cls.asSubclass(CompressionCodec.class));
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalArgumentException("Compression codec " + codecSubstring + " not found.", ex);
                }
            }
        }
        return result;
    }

    public static void setCodecClasses(Configuration conf, List<Class> classes) {
        StringBuilder buf = new StringBuilder();
        Iterator<Class> itr = classes.iterator();
        if (itr.hasNext()) {
            Class cls = itr.next();
            buf.append(cls.getName());
            while (itr.hasNext()) {
                buf.append(',');
                buf.append(itr.next().getName());
            }
        }
        conf.set("io.compression.codecs", buf.toString());
    }

    public CompressionCodecFactory(Configuration conf) {
        this.codecsByName = new HashMap<String, CompressionCodec>();
        List<Class<? extends CompressionCodec>> codecClasses = CompressionCodecFactory.getCodecClasses(conf);
        if (codecClasses == null || codecClasses.isEmpty()) {
            this.addCodec(new GzipCodec());
            this.addCodec(new DefaultCodec());
        } else {
            for (Class<? extends CompressionCodec> codecClass : codecClasses) {
                this.addCodec(ReflectionUtils.newInstance(codecClass, conf));
            }
        }
    }

    public CompressionCodec getCodec(Path file) {
        String potentialSuffix;
        String filename;
        String reversedFilename;
        SortedMap<String, CompressionCodec> subMap;
        CompressionCodec result = null;
        if (this.codecs != null && !(subMap = this.codecs.headMap(reversedFilename = new StringBuilder(filename = file.getName()).reverse().toString())).isEmpty() && reversedFilename.startsWith(potentialSuffix = subMap.lastKey())) {
            result = (CompressionCodec)this.codecs.get(potentialSuffix);
        }
        return result;
    }

    public CompressionCodec getCodecByClassName(String classname) {
        if (this.codecsByClassName == null) {
            return null;
        }
        return this.codecsByClassName.get(classname);
    }

    public CompressionCodec getCodecByName(String codecName) {
        if (this.codecsByClassName == null) {
            return null;
        }
        CompressionCodec codec = this.getCodecByClassName(codecName);
        if (codec == null) {
            codec = this.codecsByName.get(StringUtils.toLowerCase(codecName));
        }
        return codec;
    }

    public Class<? extends CompressionCodec> getCodecClassByName(String codecName) {
        CompressionCodec codec = this.getCodecByName(codecName);
        if (codec == null) {
            return null;
        }
        return codec.getClass();
    }

    public static String removeSuffix(String filename, String suffix) {
        if (filename.endsWith(suffix)) {
            return filename.substring(0, filename.length() - suffix.length());
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        boolean encode = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-in".equals(args[i])) {
                encode = true;
                continue;
            }
            if ("-out".equals(args[i])) {
                encode = false;
                continue;
            }
            CompressionCodec codec = factory.getCodec(new Path(args[i]));
            if (codec == null) {
                System.out.println("Codec for " + args[i] + " not found.");
                continue;
            }
            if (encode) {
                CompressionOutputStream out = null;
                InputStream in = null;
                try {
                    out = codec.createOutputStream(new FileOutputStream(args[i]));
                    byte[] buffer = new byte[100];
                    String inFilename = CompressionCodecFactory.removeSuffix(args[i], codec.getDefaultExtension());
                    in = new FileInputStream(inFilename);
                    int len = in.read(buffer);
                    while (len > 0) {
                        out.write(buffer, 0, len);
                        len = in.read(buffer);
                    }
                    continue;
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
            }
            try (CompressionInputStream in = null;){
                in = codec.createInputStream(new FileInputStream(args[i]));
                byte[] buffer = new byte[100];
                int len = in.read(buffer);
                while (len > 0) {
                    System.out.write(buffer, 0, len);
                    len = in.read(buffer);
                }
                continue;
            }
        }
    }
}

