/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.TaskAttemptContext;

public class CustomOutputCommitter
extends OutputCommitter {
    public static final String JOB_SETUP_FILE_NAME = "_job_setup";
    public static final String JOB_COMMIT_FILE_NAME = "_job_commit";
    public static final String JOB_ABORT_FILE_NAME = "_job_abort";
    public static final String TASK_SETUP_FILE_NAME = "_task_setup";
    public static final String TASK_ABORT_FILE_NAME = "_task_abort";
    public static final String TASK_COMMIT_FILE_NAME = "_task_commit";

    public void setupJob(JobContext jobContext) throws IOException {
        this.writeFile(jobContext.getJobConf(), JOB_SETUP_FILE_NAME);
    }

    public void commitJob(JobContext jobContext) throws IOException {
        super.commitJob(jobContext);
        this.writeFile(jobContext.getJobConf(), JOB_COMMIT_FILE_NAME);
    }

    public void abortJob(JobContext jobContext, int status) throws IOException {
        super.abortJob(jobContext, status);
        this.writeFile(jobContext.getJobConf(), JOB_ABORT_FILE_NAME);
    }

    public void setupTask(TaskAttemptContext taskContext) throws IOException {
        this.writeFile(taskContext.getJobConf(), TASK_SETUP_FILE_NAME);
    }

    public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
        return true;
    }

    public void commitTask(TaskAttemptContext taskContext) throws IOException {
        this.writeFile(taskContext.getJobConf(), TASK_COMMIT_FILE_NAME);
    }

    public void abortTask(TaskAttemptContext taskContext) throws IOException {
        this.writeFile(taskContext.getJobConf(), TASK_ABORT_FILE_NAME);
    }

    private void writeFile(JobConf conf, String filename) throws IOException {
        System.out.println("writing file ----" + filename);
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)conf);
        FileSystem fs = outputPath.getFileSystem((Configuration)conf);
        fs.create(new Path(outputPath, filename)).close();
    }
}

