/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;

public final class ByteObjectArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new ByteObjectArrayStringConverterFactory();

    private ByteObjectArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls == Byte[].class) {
            return ByteArrayStringConverter.INSTANCE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum ByteArrayStringConverter implements StringConverter<Byte[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Byte[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length);
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] == null) {
                        buf.append('-').append('-');
                        continue;
                    }
                    byte b = array[i];
                    buf.append(ByteArrayStringConverter.HEX.charAt((b & 0xF0) >>> 4)).append(ByteArrayStringConverter.HEX.charAt(b & 0xF));
                }
                return buf.toString();
            }

            @Override
            public Byte[] convertFromString(Class<? extends Byte[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                if (str.length() % 2 == 1) {
                    throw new IllegalArgumentException("Invalid Byte[] string");
                }
                Byte[] array = new Byte[str.length() / 2];
                for (int i = 0; i < array.length; ++i) {
                    String in = str.substring(i * 2, i * 2 + 2);
                    array[i] = in.equals("--") ? null : Byte.valueOf((byte)Integer.parseInt(in, 16));
                }
                return array;
            }
        };

        private static final Byte[] EMPTY;
        private static final String HEX = "0123456789ABCDEF";

        static {
            EMPTY = new Byte[0];
        }
    }
}

