/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytes(InputStream in, OutputStream out, int buffSize, boolean close) throws IOException {
        try {
            IOUtils.copyBytes(in, out, buffSize);
            if (close) {
                out.close();
                out = null;
                in.close();
                in = null;
            }
        }
        finally {
            if (close) {
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
            }
        }
    }

    public static void copyBytes(InputStream in, OutputStream out, int buffSize) throws IOException {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        int bytesRead = in.read(buf);
        while (bytesRead >= 0) {
            out.write(buf, 0, bytesRead);
            if (ps != null && ps.checkError()) {
                throw new IOException("Unable to write to output stream.");
            }
            bytesRead = in.read(buf);
        }
    }

    public static void copyBytes(InputStream in, OutputStream out, Configuration conf) throws IOException {
        IOUtils.copyBytes(in, out, conf.getInt("io.file.buffer.size", 4096), true);
    }

    public static void copyBytes(InputStream in, OutputStream out, Configuration conf, boolean close) throws IOException {
        IOUtils.copyBytes(in, out, conf.getInt("io.file.buffer.size", 4096), close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytes(InputStream in, OutputStream out, long count, boolean close) throws IOException {
        byte[] buf = new byte[4096];
        try {
            int bytesToRead;
            int bytesRead;
            for (long bytesRemaining = count; bytesRemaining > 0L && (bytesRead = in.read(buf, 0, bytesToRead = (int)(bytesRemaining < (long)buf.length ? bytesRemaining : (long)buf.length))) != -1; bytesRemaining -= (long)bytesRead) {
                out.write(buf, 0, bytesRead);
            }
            if (close) {
                out.close();
                out = null;
                in.close();
                in = null;
            }
        }
        finally {
            if (close) {
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
            }
        }
    }

    public static int wrappedReadForCompressedData(InputStream is, byte[] buf, int off, int len) throws IOException {
        try {
            return is.read(buf, off, len);
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Throwable t) {
            throw new IOException("Error while reading compressed data", t);
        }
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    public static void skipFully(InputStream in, long len) throws IOException {
        long ret;
        for (long amt = len; amt > 0L; amt -= ret) {
            ret = in.skip(amt);
            if (ret != 0L) continue;
            int b = in.read();
            if (b == -1) {
                throw new EOFException("Premature EOF from inputStream after skipping " + (len - amt) + " byte(s).");
            }
            ret = 1L;
        }
    }

    public static void cleanup(Log log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug((Object)("Exception in closing " + c), (Throwable)e);
            }
        }
    }

    public static void closeStream(Closeable stream) {
        IOUtils.cleanup(null, stream);
    }

    public static void closeSocket(Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void writeFully(WritableByteChannel bc, ByteBuffer buf) throws IOException {
        do {
            bc.write(buf);
        } while (buf.remaining() > 0);
    }

    public static void writeFully(FileChannel fc, ByteBuffer buf, long offset) throws IOException {
        do {
            offset += (long)fc.write(buf, offset);
        } while (buf.remaining() > 0);
    }

    public static List<String> listDirectory(File dir, FilenameFilter filter) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir.toPath());){
            for (Path entry : stream) {
                String fileName = entry.getFileName().toString();
                if (filter != null && !filter.accept(dir, fileName)) continue;
                list.add(fileName);
            }
        }
        catch (DirectoryIteratorException e) {
            throw e.getCause();
        }
        return list;
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

