/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import java.util.HashMap;
import java.util.Map;

final class MagicMimeEntryOperation {
    private static final Map operationID2operation = new HashMap();
    public static final MagicMimeEntryOperation EQUALS = new MagicMimeEntryOperation('=');
    public static final MagicMimeEntryOperation LESS_THAN = new MagicMimeEntryOperation('<');
    public static final MagicMimeEntryOperation GREATER_THAN = new MagicMimeEntryOperation('>');
    public static final MagicMimeEntryOperation AND = new MagicMimeEntryOperation('&');
    public static final MagicMimeEntryOperation CLEAR = new MagicMimeEntryOperation('^');
    public static final MagicMimeEntryOperation NEGATED = new MagicMimeEntryOperation('~');
    public static final MagicMimeEntryOperation ANY = new MagicMimeEntryOperation('x');
    public static final MagicMimeEntryOperation NOT_EQUALS = new MagicMimeEntryOperation('!');
    private final char operationID;

    public static MagicMimeEntryOperation getOperation(char operationID) {
        Character operationIDCharacter = new Character(operationID);
        return (MagicMimeEntryOperation)operationID2operation.get(operationIDCharacter);
    }

    public static MagicMimeEntryOperation getOperationForStringField(String content) {
        MagicMimeEntryOperation operation = MagicMimeEntryOperation.getOperation(content);
        if (EQUALS.equals(operation) || LESS_THAN.equals(operation) || GREATER_THAN.equals(operation)) {
            return operation;
        }
        return EQUALS;
    }

    public static MagicMimeEntryOperation getOperationForNumberField(String content) {
        return MagicMimeEntryOperation.getOperation(content);
    }

    private static MagicMimeEntryOperation getOperation(String content) {
        if (content.length() == 0) {
            return EQUALS;
        }
        MagicMimeEntryOperation operation = MagicMimeEntryOperation.getOperation(content.charAt(0));
        if (operation == null) {
            return EQUALS;
        }
        return operation;
    }

    private static void registerOperation(MagicMimeEntryOperation operation) {
        Character operationIDCharacter = new Character(operation.getOperationID());
        if (operationID2operation.containsKey(operationIDCharacter)) {
            throw new IllegalStateException("Duplicate registration of operation " + operationIDCharacter);
        }
        operationID2operation.put(operationIDCharacter, operation);
    }

    MagicMimeEntryOperation(char operationID) {
        this.operationID = operationID;
        MagicMimeEntryOperation.registerOperation(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.operationID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MagicMimeEntryOperation other = (MagicMimeEntryOperation)obj;
        return this.operationID == other.operationID;
    }

    public final char getOperationID() {
        return this.operationID;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '[' + this.operationID + ']';
    }
}

