/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Task;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public interface MapOutputCollector<K, V> {
    public void init(Context var1) throws IOException, ClassNotFoundException;

    public void collect(K var1, V var2, int var3) throws IOException, InterruptedException;

    public void close() throws IOException, InterruptedException;

    public void flush() throws IOException, InterruptedException, ClassNotFoundException;

    @InterfaceAudience.LimitedPrivate(value={"MapReduce"})
    @InterfaceStability.Unstable
    public static class Context {
        private final MapTask mapTask;
        private final JobConf jobConf;
        private final Task.TaskReporter reporter;

        public Context(MapTask mapTask, JobConf jobConf, Task.TaskReporter reporter) {
            this.mapTask = mapTask;
            this.jobConf = jobConf;
            this.reporter = reporter;
        }

        public MapTask getMapTask() {
            return this.mapTask;
        }

        public JobConf getJobConf() {
            return this.jobConf;
        }

        public Task.TaskReporter getReporter() {
            return this.reporter;
        }
    }
}

