/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.portlet.MyFacesGenericPortlet;
import org.apache.myfaces.portlet.PortletUtil;

public class PortletViewHandler
extends ViewHandlerWrapper {
    private final ViewHandler _viewHandler;
    private static final Log log = LogFactory.getLog(PortletViewHandler.class);

    public PortletViewHandler(ViewHandler viewHandler) {
        this._viewHandler = viewHandler;
    }

    protected ViewHandler getWrapped() {
        return this._viewHandler;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (PortletUtil.isPortletRequest(context)) {
            PortletRequest request = (PortletRequest)context.getExternalContext().getRequest();
            String portletViewId = request.getParameter(MyFacesGenericPortlet.VIEW_ID);
            Application application = context.getApplication();
            ViewHandler applicationViewHandler = application.getViewHandler();
            String renderKitId = applicationViewHandler.calculateRenderKitId(context);
            UIViewRoot viewRoot = application.getStateManager().restoreView(context, portletViewId, renderKitId);
            return viewRoot;
        }
        return super.restoreView(context, viewId);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot viewRoot = super.createView(context, viewId);
        if (PortletUtil.isPortletRequest(context)) {
            PortletRequest request = (PortletRequest)context.getExternalContext().getRequest();
            viewRoot.setViewId(request.getParameter(MyFacesGenericPortlet.VIEW_ID));
        }
        return viewRoot;
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (PortletUtil.isRenderResponse(context)) {
            RenderResponse response = (RenderResponse)context.getExternalContext().getResponse();
            PortletURL url = response.createActionURL();
            url.setParameter(MyFacesGenericPortlet.VIEW_ID, viewId);
            return url.toString();
        }
        return super.getActionURL(context, viewId);
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (PortletUtil.isPortletRequest(context)) {
            if (viewToRender.isRendered()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"It is a portlet request. Dispatching to view");
                }
                context.getExternalContext().dispatch(viewToRender.getViewId());
            }
        } else {
            super.renderView(context, viewToRender);
        }
    }
}

