/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import java.io.Closeable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.vfs.Cluster;
import jetbrains.exodus.vfs.ClusterConverter;
import jetbrains.exodus.vfs.ClusterKey;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.File;
import jetbrains.exodus.vfs.IOCancellingPolicy;
import jetbrains.exodus.vfs.IOCancellingPolicyProvider;
import jetbrains.exodus.vfs.VirtualFileSystem;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0016J\u0006\u0010#\u001a\u00020 J\u0006\u0010$\u001a\u00020\u001aJ\u0006\u0010%\u001a\u00020\u001aJ\u0006\u0010&\u001a\u00020 J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010+\u001a\u00020\nR\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ljetbrains/exodus/vfs/ClusterIterator;", "Ljava/io/Closeable;", "vfs", "Ljetbrains/exodus/vfs/VirtualFileSystem;", "txn", "Ljetbrains/exodus/env/Transaction;", "file", "Ljetbrains/exodus/vfs/File;", "(Ljetbrains/exodus/vfs/VirtualFileSystem;Ljetbrains/exodus/env/Transaction;Ljetbrains/exodus/vfs/File;)V", "fd", "", "position", "(Ljetbrains/exodus/vfs/VirtualFileSystem;Ljetbrains/exodus/env/Transaction;JJ)V", "cancellingPolicy", "Ljetbrains/exodus/vfs/IOCancellingPolicy;", "getCancellingPolicy", "()Ljetbrains/exodus/vfs/IOCancellingPolicy;", "cancellingPolicy$delegate", "Lkotlin/Lazy;", "<set-?>", "Ljetbrains/exodus/vfs/Cluster;", "current", "getCurrent", "()Ljetbrains/exodus/vfs/Cluster;", "cursor", "Ljetbrains/exodus/env/Cursor;", "", "isClosed", "()Z", "getTxn", "()Ljetbrains/exodus/env/Transaction;", "adjustCurrentCluster", "", "cancelIfNeeded", "close", "deleteCurrent", "hasCluster", "isObsolete", "moveToNext", "readCluster", "it", "Ljetbrains/exodus/ByteIterable;", "seek", "size", "xodus-vfs"})
public final class ClusterIterator
implements Closeable {
    @NotNull
    private final VirtualFileSystem vfs;
    @NotNull
    private final Transaction txn;
    private final long fd;
    @NotNull
    private final Cursor cursor;
    @NotNull
    private final Lazy cancellingPolicy$delegate;
    @Nullable
    private Cluster current;
    private boolean isClosed;

    @JvmOverloads
    public ClusterIterator(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fd, long position) {
        Intrinsics.checkNotNullParameter((Object)vfs, (String)"vfs");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        this.vfs = vfs;
        this.txn = txn;
        this.fd = fd;
        Cursor cursor = this.vfs.getContents().openCursor(this.txn);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"vfs.contents.openCursor(txn)");
        this.cursor = cursor;
        this.cancellingPolicy$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<IOCancellingPolicy>(this){
            final /* synthetic */ ClusterIterator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final IOCancellingPolicy invoke() {
                IOCancellingPolicy iOCancellingPolicy;
                IOCancellingPolicyProvider iOCancellingPolicyProvider = ClusterIterator.access$getVfs$p(this.this$0).getCancellingPolicyProvider();
                if (iOCancellingPolicyProvider == null) {
                    iOCancellingPolicy = null;
                } else {
                    IOCancellingPolicyProvider iOCancellingPolicyProvider2 = iOCancellingPolicyProvider;
                    ClusterIterator clusterIterator = this.this$0;
                    IOCancellingPolicyProvider $this$invoke_u24lambda_u2d1 = iOCancellingPolicyProvider2;
                    boolean bl = false;
                    iOCancellingPolicy = (IOCancellingPolicy)clusterIterator.getTxn().getUserObject((Object)"CP_KEY");
                    if (iOCancellingPolicy == null) {
                        IOCancellingPolicy iOCancellingPolicy2;
                        IOCancellingPolicy $this$invoke_u24lambda_u2d1_u24lambda_u2d0 = iOCancellingPolicy2 = $this$invoke_u24lambda_u2d1.getPolicy();
                        boolean bl2 = false;
                        clusterIterator.getTxn().setUserObject((Object)"CP_KEY", (Object)$this$invoke_u24lambda_u2d1_u24lambda_u2d0);
                        IOCancellingPolicy iOCancellingPolicy3 = iOCancellingPolicy2;
                        Intrinsics.checkNotNullExpressionValue((Object)iOCancellingPolicy3, (String)"policy.apply {\n         \u2026_KEY, this)\n            }");
                        iOCancellingPolicy = iOCancellingPolicy3;
                    }
                }
                return iOCancellingPolicy;
            }
        }));
        ((TransactionBase)this.txn).checkIsFinished();
        if (position >= 0L) {
            this.seek(position);
        }
        this.isClosed = false;
    }

    public /* synthetic */ ClusterIterator(VirtualFileSystem virtualFileSystem, Transaction transaction, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l2 = 0L;
        }
        this(virtualFileSystem, transaction, l, l2);
    }

    @NotNull
    public final Transaction getTxn() {
        return this.txn;
    }

    private final IOCancellingPolicy getCancellingPolicy() {
        Lazy lazy = this.cancellingPolicy$delegate;
        return (IOCancellingPolicy)lazy.getValue();
    }

    @Nullable
    public final Cluster getCurrent() {
        return this.current;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public ClusterIterator(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)vfs, (String)"vfs");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(vfs, txn, file.getDescriptor(), 0L, 8, null);
    }

    public final void seek(long position) {
        block6: {
            ByteIterable it;
            ClusteringStrategy cs;
            long pos;
            block4: {
                int firstClusterSize;
                block5: {
                    pos = position;
                    ClusteringStrategy clusteringStrategy = this.vfs.getConfig().getClusteringStrategy();
                    Intrinsics.checkNotNullExpressionValue((Object)clusteringStrategy, (String)"vfs.config.clusteringStrategy");
                    cs = clusteringStrategy;
                    it = null;
                    if (!cs.isLinear()) break block4;
                    firstClusterSize = cs.getFirstClusterSize();
                    it = this.cursor.getSearchKeyRange((ByteIterable)ClusterKey.Companion.toByteIterable(this.fd, pos / (long)firstClusterSize));
                    if (it != null) break block5;
                    this.current = null;
                    break block6;
                }
                this.current = this.readCluster(it);
                this.adjustCurrentCluster();
                Cluster currentCluster = this.current;
                if (currentCluster == null) break block6;
                currentCluster.setStartingPosition(currentCluster.getClusterNumber() * (long)firstClusterSize);
                break block6;
            }
            it = this.cursor.getSearchKeyRange((ByteIterable)ClusterKey.Companion.toByteIterable(this.fd, 0L));
            if (it == null) {
                this.current = null;
            } else {
                int maxClusterSize = cs.getMaxClusterSize();
                long clusterSize = 0L;
                this.current = this.readCluster(it);
                long startingPosition = 0L;
                this.adjustCurrentCluster();
                while (this.current != null) {
                    Cluster notNullCluster = (Cluster)KodusKt.getNotNull((Object)this.current);
                    if (clusterSize < (long)maxClusterSize) {
                        clusterSize = notNullCluster.getSize();
                    }
                    notNullCluster.setStartingPosition(startingPosition);
                    if (pos < clusterSize) break;
                    pos -= clusterSize;
                    startingPosition += clusterSize;
                    this.moveToNext();
                }
            }
        }
    }

    public final long size() {
        long result = 0L;
        ClusteringStrategy clusteringStrategy = this.vfs.getConfig().getClusteringStrategy();
        Intrinsics.checkNotNullExpressionValue((Object)clusteringStrategy, (String)"vfs.config.clusteringStrategy");
        ClusteringStrategy cs = clusteringStrategy;
        if (cs.isLinear()) {
            long clusterSize = cs.getFirstClusterSize();
            if (this.cursor.getSearchKeyRange((ByteIterable)ClusterKey.Companion.toByteIterable(this.fd + 1L, 0L)) != null && this.cursor.getPrev() || this.cursor.getPrev()) {
                ByteIterable byteIterable = this.cursor.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"cursor.key");
                ClusterKey clusterKey = new ClusterKey(byteIterable);
                if (clusterKey.getDescriptor() == this.fd) {
                    long l = clusterKey.getClusterNumber() * clusterSize;
                    byteIterable = this.cursor.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"cursor.value");
                    return l + (long)this.readCluster(byteIterable).getSize();
                }
            }
            this.seek(0L);
            Cluster previous = null;
            while (this.hasCluster()) {
                if (previous != null) {
                    result += clusterSize;
                }
                previous = this.current;
                this.moveToNext();
            }
            if (previous != null) {
                result += (long)previous.getSize();
            }
        } else {
            this.seek(0L);
            while (this.hasCluster()) {
                result += (long)((Cluster)KodusKt.getNotNull((Object)this.current)).getSize();
                this.moveToNext();
            }
        }
        return result;
    }

    public final boolean hasCluster() {
        return this.current != null;
    }

    public final void moveToNext() {
        this.cancelIfNeeded();
        if (this.current != null) {
            if (!this.cursor.getNext()) {
                this.current = null;
            } else {
                ByteIterable byteIterable = this.cursor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"cursor.value");
                this.current = this.readCluster(byteIterable);
                this.adjustCurrentCluster();
            }
        }
    }

    public final void deleteCurrent() {
        if (this.current != null) {
            this.cursor.deleteCurrent();
        }
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.cursor.close();
            this.isClosed = true;
        }
    }

    public final boolean isObsolete() {
        return this.txn.isFinished();
    }

    private final Cluster readCluster(ByteIterable it) {
        ByteIterable byteIterable;
        ClusterConverter clusterConverter;
        ClusterConverter clusterConverter2 = clusterConverter = this.vfs.getClusterConverter();
        if (clusterConverter2 == null) {
            byteIterable = it;
        } else {
            byteIterable = clusterConverter2.onRead(it);
            if (byteIterable == null) {
                byteIterable = it;
            }
        }
        ByteIterable byteIterable2 = byteIterable;
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable2, (String)"clusterConverter?.onRead(it) ?: it");
        return new Cluster(byteIterable2);
    }

    private final void adjustCurrentCluster() {
        ByteIterable byteIterable = this.cursor.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"cursor.key");
        ClusterKey clusterKey = new ClusterKey(byteIterable);
        if (clusterKey.getDescriptor() != this.fd) {
            this.current = null;
        } else {
            ((Cluster)KodusKt.getNotNull((Object)this.current)).setClusterNumber(clusterKey.getClusterNumber());
        }
    }

    private final void cancelIfNeeded() {
        IOCancellingPolicy iOCancellingPolicy = this.getCancellingPolicy();
        if (iOCancellingPolicy != null) {
            IOCancellingPolicy $this$cancelIfNeeded_u24lambda_u2d0 = iOCancellingPolicy;
            boolean bl = false;
            if ($this$cancelIfNeeded_u24lambda_u2d0.needToCancel()) {
                $this$cancelIfNeeded_u24lambda_u2d0.doCancel();
            }
        }
    }

    @JvmOverloads
    public ClusterIterator(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fd) {
        Intrinsics.checkNotNullParameter((Object)vfs, (String)"vfs");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        this(vfs, txn, fd, 0L, 8, null);
    }

    public static final /* synthetic */ VirtualFileSystem access$getVfs$p(ClusterIterator $this) {
        return $this.vfs;
    }
}

