/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.O3Basket;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjList;
import io.questdb.std.ReadOnlyObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionTask;
import java.util.concurrent.atomic.AtomicInteger;

public class O3PartitionJob
extends AbstractQueueConsumerJob<O3PartitionTask> {
    private static final Log LOG = LogFactory.getLog(O3PartitionJob.class);

    public O3PartitionJob(MessageBus messageBus) {
        super(messageBus.getO3PartitionQueue(), messageBus.getO3PartitionSubSeq());
    }

    public static void processPartition(Path pathToTable, int partitionBy, ObjList<MemoryMA> columns, ReadOnlyObjList<? extends MemoryCR> oooColumns, long srcOooLo, long srcOooHi, long srcOooMax, long o3TimestampMin, long o3TimestampMax, long partitionTimestamp, long maxTimestamp, long srcDataMax, long srcDataTxn, boolean last, long txn, long sortedTimestampsAddr, TableWriter tableWriter, AtomicInteger columnCounter, O3Basket o3Basket, long colTopSinkAddr) {
        long o3TimestampLo = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooLo);
        TableRecordMetadata metadata = tableWriter.getMetadata();
        int timestampIndex = metadata.getTimestampIndex();
        Path path = Path.getThreadLocal(pathToTable);
        TableUtils.setPathForPartition(path, partitionBy, o3TimestampLo, false);
        int pplen = path.length();
        TableUtils.txnPartitionConditionally(path, srcDataTxn);
        int plen = path.length();
        int srcTimestampFd = 0;
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataMax < 1L) {
            if (!last) {
                try {
                    LOG.debug().$("would create [path=").utf8(path.slash$()).I$();
                    TableUtils.createDirsOrFail(ff, path, tableWriter.getConfiguration().getMkDirMode());
                }
                catch (Throwable e) {
                    LOG.error().$("process new partition error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                    tableWriter.o3BumpErrorCount();
                    tableWriter.o3ClockDownPartitionUpdateCount();
                    tableWriter.o3CountDownDoneLatch();
                    throw e;
                }
            }
            O3PartitionJob.publishOpenColumnTasks(txn, columns, oooColumns, pathToTable, srcOooLo, srcOooHi, srcOooMax, o3TimestampMin, o3TimestampMax, o3TimestampLo, partitionTimestamp, 0, 0L, 0L, 0, 0L, 0L, 0L, 0L, 0, 0L, 0L, 0L, srcDataTxn, 5, 0, 0L, 0L, timestampIndex, sortedTimestampsAddr, tableWriter, columnCounter, o3Basket, colTopSinkAddr);
        } else {
            int openColumnMode;
            long suffixHi;
            long suffixLo;
            int suffixType;
            long mergeO3Hi;
            long mergeO3Lo;
            long mergeDataHi;
            long mergeDataLo;
            int mergeType;
            long prefixHi;
            long prefixLo;
            int prefixType;
            long dataTimestampHi;
            long srcTimestampAddr = 0L;
            long srcTimestampSize = 0L;
            try {
                int branch;
                if (last) {
                    dataTimestampHi = maxTimestamp;
                    srcTimestampSize = srcDataMax * 8L;
                    srcTimestampFd = -columns.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex)).getFd();
                    srcTimestampAddr = TableUtils.mapRW(ff, -srcTimestampFd, srcTimestampSize, 2);
                } else {
                    srcTimestampSize = srcDataMax * 8L;
                    TableUtils.dFile(path.trimTo(plen), metadata.getColumnName(timestampIndex), -1L);
                    srcTimestampFd = TableUtils.openRW(ff, path, LOG, tableWriter.getConfiguration().getWriterFileOpenOpts());
                    srcTimestampAddr = TableUtils.mapRW(ff, srcTimestampFd, srcTimestampSize, 2);
                    dataTimestampHi = Unsafe.getUnsafe().getLong(srcTimestampAddr + srcTimestampSize - 8L);
                }
                long dataTimestampLo = Unsafe.getUnsafe().getLong(srcTimestampAddr);
                prefixType = -1;
                prefixLo = -1L;
                prefixHi = -1L;
                mergeType = -1;
                mergeDataLo = -1L;
                mergeDataHi = -1L;
                mergeO3Lo = -1L;
                mergeO3Hi = -1L;
                suffixType = -1;
                suffixLo = -1L;
                suffixHi = -1L;
                assert (srcTimestampFd != -1 && srcTimestampFd != 1);
                if (o3TimestampLo > dataTimestampLo) {
                    if (o3TimestampLo >= dataTimestampHi) {
                        branch = 1;
                        suffixType = 1;
                        suffixLo = srcOooLo;
                        suffixHi = srcOooHi;
                    } else {
                        prefixType = 2;
                        prefixLo = 0L;
                        prefixHi = Vect.boundedBinarySearch64Bit(srcTimestampAddr, o3TimestampLo, 0L, srcDataMax - 1L, 1);
                        mergeDataLo = prefixHi + 1L;
                        mergeO3Lo = srcOooLo;
                        if (o3TimestampMax < dataTimestampHi) {
                            branch = 2;
                            mergeO3Hi = srcOooHi;
                            mergeDataHi = Vect.boundedBinarySearch64Bit(srcTimestampAddr, o3TimestampMax - 1L, mergeDataLo, srcDataMax - 1L, 1);
                            mergeType = mergeDataLo > mergeDataHi ? 1 : 3;
                            suffixType = 2;
                            suffixLo = mergeDataHi + 1L;
                            suffixHi = srcDataMax - 1L;
                            assert (suffixLo <= suffixHi);
                        } else if (o3TimestampMax > dataTimestampHi) {
                            branch = 3;
                            mergeO3Hi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, dataTimestampHi, srcOooLo, srcOooHi, -1);
                            mergeDataHi = srcDataMax - 1L;
                            mergeType = 3;
                            suffixType = 1;
                            suffixLo = mergeO3Hi + 1L;
                            suffixHi = srcOooHi;
                        } else {
                            branch = 4;
                            mergeType = 3;
                            mergeO3Hi = srcOooHi;
                            mergeDataHi = srcDataMax - 1L;
                        }
                    }
                } else {
                    prefixType = 1;
                    prefixLo = srcOooLo;
                    if (dataTimestampLo < o3TimestampMax) {
                        mergeDataLo = 0L;
                        prefixHi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, dataTimestampLo, srcOooLo, srcOooHi, 1);
                        mergeO3Lo = prefixHi + 1L;
                        if (o3TimestampMax < dataTimestampHi) {
                            branch = 5;
                            mergeType = 3;
                            mergeO3Hi = srcOooHi;
                            mergeDataHi = Vect.boundedBinarySearch64Bit(srcTimestampAddr, o3TimestampMax, 0L, srcDataMax - 1L, 1);
                            suffixLo = mergeDataHi + 1L;
                            suffixType = 2;
                            suffixHi = srcDataMax - 1L;
                        } else if (o3TimestampMax > dataTimestampHi) {
                            branch = 6;
                            mergeDataHi = srcDataMax - 1L;
                            mergeO3Hi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, dataTimestampHi - 1L, mergeO3Lo, srcOooHi, 1);
                            mergeType = mergeO3Lo > mergeO3Hi ? 2 : 3;
                            if (mergeO3Hi < srcOooHi) {
                                suffixLo = mergeO3Hi + 1L;
                                suffixType = 1;
                                suffixHi = Math.max(suffixLo, srcOooHi);
                            }
                        } else {
                            branch = 7;
                            mergeType = 3;
                            mergeO3Hi = srcOooHi;
                            mergeDataHi = srcDataMax - 1L;
                        }
                    } else {
                        branch = 8;
                        prefixHi = srcOooHi;
                        suffixType = 2;
                        suffixLo = 0L;
                        suffixHi = srcDataMax - 1L;
                    }
                }
                LOG.debug().$("o3 merge [branch=").$(branch).$(", prefixType=").$(prefixType).$(", prefixLo=").$(prefixLo).$(", prefixHi=").$(prefixHi).$(", o3TimestampLo=").$ts(o3TimestampLo).$(", o3TimestampMin=").$ts(o3TimestampMin).$(", o3TimestampMax=").$ts(o3TimestampMax).$(", dataTimestampLo=").$ts(dataTimestampLo).$(", dataTimestampHi=").$ts(dataTimestampHi).$(", partitionTimestamp=").$ts(partitionTimestamp).$(", srcDataMax=").$(srcDataMax).$(", mergeType=").$(mergeType).$(", mergeDataLo=").$(mergeDataLo).$(", mergeDataHi=").$(mergeDataHi).$(", mergeO3Lo=").$(mergeO3Lo).$(", mergeO3Hi=").$(mergeO3Hi).$(", suffixType=").$(suffixType).$(", suffixLo=").$(suffixLo).$(", suffixHi=").$(suffixHi).$(", table=").$(pathToTable).I$();
                if (prefixType == -1) {
                    openColumnMode = 1;
                } else {
                    TableUtils.txnPartition(path.trimTo(pplen), txn);
                    TableUtils.createDirsOrFail(ff, path.slash$(), tableWriter.getConfiguration().getMkDirMode());
                    openColumnMode = last ? 4 : 3;
                }
            }
            catch (Throwable e) {
                LOG.error().$("process existing partition error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
                O3Utils.close(ff, srcTimestampFd);
                tableWriter.o3BumpErrorCount();
                tableWriter.o3ClockDownPartitionUpdateCount();
                tableWriter.o3CountDownDoneLatch();
                throw e;
            }
            long timestampMax = Math.max(o3TimestampMax, dataTimestampHi);
            O3PartitionJob.publishOpenColumnTasks(txn, columns, oooColumns, pathToTable, srcOooLo, srcOooHi, srcOooMax, o3TimestampMin, timestampMax, o3TimestampLo, partitionTimestamp, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeO3Lo, mergeO3Hi, suffixType, suffixLo, suffixHi, srcDataMax, srcDataTxn, openColumnMode, srcTimestampFd, srcTimestampAddr, srcTimestampSize, timestampIndex, sortedTimestampsAddr, tableWriter, columnCounter, o3Basket, colTopSinkAddr);
        }
    }

    public static void processPartition(O3PartitionTask task, long cursor, Sequence subSeq) {
        Path pathToTable = task.getPathToTable();
        int partitionBy = task.getPartitionBy();
        ObjList<MemoryMA> columns = task.getColumns();
        ReadOnlyObjList<? extends MemoryCR> oooColumns = task.getO3Columns();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long oooTimestampMin = task.getOooTimestampMin();
        long oooTimestampMax = task.getOooTimestampMax();
        long partitionTimestamp = task.getPartitionTimestamp();
        long maxTimestamp = task.getMaxTimestamp();
        long srcDataMax = task.getSrcDataMax();
        long srcDataTxn = task.getSrcNameTxn();
        boolean last = task.isLast();
        long txn = task.getTxn();
        long sortedTimestampsAddr = task.getSortedTimestampsAddr();
        TableWriter tableWriter = task.getTableWriter();
        AtomicInteger columnCounter = task.getColumnCounter();
        O3Basket o3Basket = task.getO3Basket();
        long colTopSinkAddr = task.getColTopSinkAddr();
        subSeq.done(cursor);
        O3PartitionJob.processPartition(pathToTable, partitionBy, columns, oooColumns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, partitionTimestamp, maxTimestamp, srcDataMax, srcDataTxn, last, txn, sortedTimestampsAddr, tableWriter, columnCounter, o3Basket, colTopSinkAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long createMergeIndex(long srcDataTimestampAddr, long sortedTimestampsAddr, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, long indexSize) {
        long index = Unsafe.malloc(indexSize, 3);
        try {
            Vect.makeTimestampIndex(srcDataTimestampAddr, mergeDataLo, mergeDataHi, index);
            long ptr = Vect.mergeTwoLongIndexesAsc(index, mergeDataHi - mergeDataLo + 1L, sortedTimestampsAddr + mergeOOOLo * 16L, mergeOOOHi - mergeOOOLo + 1L);
            Unsafe.recordMemAlloc(indexSize, 3);
            long l = ptr;
            return l;
        }
        finally {
            Unsafe.free(index, indexSize, 3);
        }
    }

    private static void publishOpenColumnTaskContended(long cursor, int openColumnMode, Path pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long oooTimestampLo, long partitionTimestamp, long srcDataTop, long srcDataMax, long srcDataTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int indexBlockCapacity, int activeFixFd, int activeVarFd, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, int columnIndex, long columnNameTxn) {
        while (cursor == -2L) {
            cursor = tableWriter.getO3OpenColumnPubSeq().next();
        }
        if (cursor > -1L) {
            O3PartitionJob.publishOpenColumnTaskHarmonized(cursor, openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, activeFixFd, activeVarFd, tableWriter, indexWriter, colTopSinkAddr, columnIndex, columnNameTxn);
        } else {
            O3OpenColumnJob.openColumn(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, indexBlockCapacity, activeFixFd, activeVarFd, tableWriter, indexWriter, colTopSinkAddr, columnIndex, columnNameTxn);
        }
    }

    private static void publishOpenColumnTaskHarmonized(long cursor, int openColumnMode, Path pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long oooTimestampLo, long partitionTimestamp, long srcDataTop, long srcDataMax, long srcDataTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int activeFixFd, int activeVarFd, TableWriter tableWriter, BitmapIndexWriter indexWriter, long colTopSinkAddr, int columnIndex, long columnNameTxn) {
        O3OpenColumnTask openColumnTask = tableWriter.getO3OpenColumnQueue().get(cursor);
        openColumnTask.of(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, indexBlockCapacity, activeFixFd, activeVarFd, tableWriter, indexWriter, colTopSinkAddr, columnIndex, columnNameTxn);
        tableWriter.getO3OpenColumnPubSeq().done(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishOpenColumnTasks(long txn, ObjList<MemoryMA> columns, ReadOnlyObjList<? extends MemoryCR> oooColumns, Path pathToTable, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long oooTimestampLo, long partitionTimestamp, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, long srcDataMax, long srcDataTxn, int openColumnMode, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int timestampIndex, long sortedTimestampsAddr, TableWriter tableWriter, AtomicInteger columnCounter, O3Basket o3Basket, long colTopSinkAddr) {
        long timestampMergeIndexAddr;
        long timestampMergeIndexSize;
        long srcOooBatchRowSize = srcOooHi - srcOooLo + 1L;
        tableWriter.addPhysicallyWrittenRows(O3OpenColumnJob.isOpenColumnModeForAppend(openColumnMode) ? srcOooBatchRowSize : srcDataMax + srcOooBatchRowSize);
        LOG.debug().$("partition [ts=").$ts(oooTimestampLo).I$();
        if (mergeType == 3) {
            timestampMergeIndexSize = (mergeDataHi - mergeDataLo + 1L) * 16L;
            assert (timestampMergeIndexSize > 0L);
            timestampMergeIndexAddr = O3PartitionJob.createMergeIndex(srcTimestampAddr, sortedTimestampsAddr, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, timestampMergeIndexSize);
        } else {
            timestampMergeIndexAddr = 0L;
            timestampMergeIndexSize = 0L;
        }
        TableRecordMetadata metadata = tableWriter.getMetadata();
        int columnCount = metadata.getColumnCount();
        columnCounter.set(TableUtils.compressColumnCount(metadata));
        int columnsInFlight = columnCount;
        if (openColumnMode == 4 || openColumnMode == 3) {
            Vect.memset(colTopSinkAddr, 8L * (long)columnCount, 0);
        }
        try {
            for (int i = 0; i < columnCount; ++i) {
                long srcOooVarAddr;
                long srcOooFixAddr;
                int activeVarFd;
                int activeFixFd;
                int columnType = metadata.getColumnType(i);
                if (columnType < 0) continue;
                int colOffset = TableWriter.getPrimaryColumnIndex(i);
                boolean notTheTimestamp = i != timestampIndex;
                MemoryCR oooMem1 = oooColumns.getQuick(colOffset);
                MemoryCR oooMem2 = oooColumns.getQuick(colOffset + 1);
                MemoryMA mem1 = columns.getQuick(colOffset);
                MemoryMA mem2 = columns.getQuick(colOffset + 1);
                if (!ColumnType.isVariableLength(columnType)) {
                    activeFixFd = mem1.getFd();
                    activeVarFd = 0;
                    srcOooFixAddr = oooMem1.addressOf(0L);
                    srcOooVarAddr = 0L;
                } else {
                    activeFixFd = mem2.getFd();
                    activeVarFd = mem1.getFd();
                    srcOooFixAddr = oooMem2.addressOf(0L);
                    srcOooVarAddr = oooMem1.addressOf(0L);
                }
                String columnName = metadata.getColumnName(i);
                boolean isIndexed = metadata.isColumnIndexed(i);
                int indexBlockCapacity = isIndexed ? metadata.getIndexValueBlockCapacity(i) : -1;
                long srcDataTop = openColumnMode == 2 || openColumnMode == 4 ? tableWriter.getColumnTop(i) : -1L;
                BitmapIndexWriter indexWriter = isIndexed ? o3Basket.nextIndexer() : null;
                try {
                    long cursor = tableWriter.getO3OpenColumnPubSeq().next();
                    long columnNameTxn = tableWriter.getColumnNameTxn(partitionTimestamp, i);
                    if (cursor > -1L) {
                        O3PartitionJob.publishOpenColumnTaskHarmonized(cursor, openColumnMode, pathToTable, columnName, columnCounter, o3Basket.nextPartCounter(), notTheTimestamp ? columnType : ColumnType.setDesignatedTimestampBit(columnType, true), timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, activeFixFd, activeVarFd, tableWriter, indexWriter, colTopSinkAddr + (long)i * 8L, i, columnNameTxn);
                        continue;
                    }
                    O3PartitionJob.publishOpenColumnTaskContended(cursor, openColumnMode, pathToTable, columnName, columnCounter, o3Basket.nextPartCounter(), notTheTimestamp ? columnType : ColumnType.setDesignatedTimestampBit(columnType, true), timestampMergeIndexAddr, timestampMergeIndexSize, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, indexBlockCapacity, activeFixFd, activeVarFd, tableWriter, indexWriter, colTopSinkAddr + (long)i * 8L, i, columnNameTxn);
                    continue;
                }
                catch (Throwable e) {
                    tableWriter.o3BumpErrorCount();
                    LOG.error().$("open column error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
                    columnsInFlight = i + 1;
                    throw e;
                }
            }
        }
        finally {
            int delta = columnsInFlight - columnCount;
            LOG.debug().$("idle [delta=").$(delta).I$();
            if (delta < 0 && columnCounter.addAndGet(delta) == 0) {
                O3CopyJob.closeColumnIdleQuick(timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
            }
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        O3PartitionJob.processPartition((O3PartitionTask)this.queue.get(cursor), cursor, this.subSeq);
        return true;
    }
}

