/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.DataAuthorizable;
import org.apache.nifi.authorization.resource.ProvenanceDataAuthorizable;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.web.ResourceNotFoundException;

public class StandardProvenanceAuthorizableFactory
implements ProvenanceAuthorizableFactory {
    private final FlowController flowController;

    public StandardProvenanceAuthorizableFactory(FlowController flowController) {
        this.flowController = flowController;
    }

    public Authorizable createLocalDataAuthorizable(String componentId) {
        DataAuthorizable authorizable;
        FlowManager flowManager = this.flowController.getFlowManager();
        String rootGroupId = flowManager.getRootGroupId();
        if (rootGroupId.equals(componentId)) {
            authorizable = new DataAuthorizable((Authorizable)flowManager.getRootGroup());
        } else {
            Connectable connectable = flowManager.findConnectable(componentId);
            if (connectable == null) {
                Connection connection = flowManager.getRootGroup().findConnection(componentId);
                if (connection == null) {
                    throw new ResourceNotFoundException("The component that generated this event is no longer part of the data flow.");
                }
                authorizable = new DataAuthorizable((Authorizable)connection.getSource());
            } else {
                authorizable = new DataAuthorizable((Authorizable)connectable);
            }
        }
        return authorizable;
    }

    public Authorizable createRemoteDataAuthorizable(String remoteGroupPortId) {
        RemoteGroupPort remoteGroupPort = this.flowController.getFlowManager().getRootGroup().findRemoteGroupPort(remoteGroupPortId);
        if (remoteGroupPort == null) {
            throw new ResourceNotFoundException("The component that generated this event is no longer part of the data flow.");
        }
        DataAuthorizable authorizable = new DataAuthorizable((Authorizable)remoteGroupPort.getRemoteProcessGroup());
        return authorizable;
    }

    public Authorizable createProvenanceDataAuthorizable(String componentId) {
        ProvenanceDataAuthorizable authorizable;
        FlowManager flowManager = this.flowController.getFlowManager();
        String rootGroupId = flowManager.getRootGroupId();
        if (rootGroupId.equals(componentId)) {
            authorizable = new ProvenanceDataAuthorizable((Authorizable)flowManager.getRootGroup());
        } else {
            Connectable connectable = flowManager.findConnectable(componentId);
            if (connectable == null) {
                Connection connection = flowManager.getRootGroup().findConnection(componentId);
                if (connection == null) {
                    throw new ResourceNotFoundException("The component that generated this event is no longer part of the data flow.");
                }
                authorizable = new ProvenanceDataAuthorizable((Authorizable)connection.getSource());
            } else {
                authorizable = new ProvenanceDataAuthorizable((Authorizable)connectable);
            }
        }
        return authorizable;
    }
}

