/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.KqueueFacade;
import io.questdb.network.NetworkError;
import io.questdb.network.SuspendEvent;

public class PipeSuspendEvent
extends SuspendEvent {
    private final KqueueFacade kqf;
    private final int readEndFd;
    private final int writeEndFd;

    public PipeSuspendEvent(KqueueFacade kqf) {
        this.kqf = kqf;
        long fds = kqf.pipe();
        if (fds < 0L) {
            throw NetworkError.instance(kqf.getNetworkFacade().errno(), "could not create PipeSuspendEvent");
        }
        this.readEndFd = (int)(fds >>> 32);
        this.writeEndFd = (int)fds;
        kqf.getNetworkFacade().bumpFdCount(this.readEndFd);
        kqf.getNetworkFacade().bumpFdCount(this.writeEndFd);
    }

    @Override
    public void _close() {
        this.kqf.getNetworkFacade().close(this.readEndFd);
        this.kqf.getNetworkFacade().close(this.writeEndFd);
    }

    @Override
    public boolean checkTriggered() {
        return this.kqf.readPipe(this.readEndFd) == 1;
    }

    @Override
    public int getFd() {
        return this.readEndFd;
    }

    @Override
    public void trigger() {
        if (this.kqf.writePipe(this.writeEndFd) < 0) {
            throw NetworkError.instance(this.kqf.getNetworkFacade().errno()).put("could not write to pipe [fd=").put(this.writeEndFd).put(']');
        }
    }
}

