/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.text;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.util.text.DateTimeMatcher;

public class RegexDateTimeMatcher
implements DateTimeMatcher {
    private final Pattern pattern;
    private final List<String> subPatterns;
    private final int minLength;
    private final int maxLength;

    private RegexDateTimeMatcher(Pattern pattern, List<String> subPatterns, int minLength, int maxLength) {
        this.pattern = pattern;
        this.subPatterns = subPatterns;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public int getMinInputLength() {
        return this.minLength;
    }

    public int getMaxInputLength() {
        return this.maxLength;
    }

    @Override
    public boolean matches(String text) {
        if (text.length() < this.minLength || text.length() > this.maxLength) {
            return false;
        }
        return this.pattern.matcher(text).matches();
    }

    public String determineMismatch(String text) {
        for (int patternsToUse = this.subPatterns.size() - 1; patternsToUse >= 0; --patternsToUse) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < patternsToUse; ++i) {
                sb.append(this.subPatterns.get(i));
            }
            String regex = "^" + sb.toString();
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(text);
            boolean found = matcher.find();
            if (!found) continue;
            return "Longest Match: <" + matcher.group(0) + "> based on pattern <" + regex + ">. The following portions did not match: " + this.subPatterns.subList(patternsToUse, this.subPatterns.size());
        }
        return "Could not match any part of the pattern";
    }

    public static class Compiler {
        private final List<String> patterns = new ArrayList<String>();
        private char currentPattern;
        private int charCount;
        private boolean patternStarted = false;
        private static final String AMPM_PATTERN;
        private static final String ERAS_PATTERN;
        private static final String MONTHS_PATTERN;
        private static final String LONG_WEEKDAY_PATTERN;
        private static final String SHORT_WEEKDAY_PATTERN;
        private static final String ZONE_NAME_PATTERN;
        private static final LengthRange AMPM_RANGE;
        private static final LengthRange ERAS_RANGE;
        private static final LengthRange MONTH_NAME_RANGE;
        private static final LengthRange LONG_WEEKDAY_RANGE;
        private static final LengthRange SHORT_WEEKDAY_RANGE;
        private static final LengthRange ZONE_NAME_RANGE;
        private LengthRange range = new LengthRange(0, 0);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RegexDateTimeMatcher compile(String format) {
            this.currentPattern = '\u0000';
            this.charCount = 0;
            char lastChar = '\u0000';
            block5: for (int i = 0; i < format.length(); ++i) {
                char c = format.charAt(i);
                if (c != lastChar) {
                    this.endPattern();
                } else {
                    ++this.charCount;
                }
                try {
                    switch (c) {
                        case '\'': {
                            i = this.copyText(format, i);
                            break;
                        }
                        default: {
                            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                                if (c != lastChar) {
                                    this.beginPattern(c);
                                }
                                lastChar = c;
                                continue block5;
                            }
                            this.appendChar(c);
                        }
                    }
                    lastChar = c;
                    continue;
                }
                catch (Throwable throwable) {
                    lastChar = c;
                    throw throwable;
                }
            }
            this.endPattern();
            StringBuilder sb = new StringBuilder();
            Iterator<String> c = this.patterns.iterator();
            while (true) {
                if (!c.hasNext()) {
                    String regex = sb.toString();
                    Pattern pattern = Pattern.compile(regex);
                    return new RegexDateTimeMatcher(pattern, this.patterns, this.range.getMinLength(), this.range.getMaxLength());
                }
                String string = c.next();
                sb.append(string);
            }
        }

        private static LengthRange lengthRange(String[] values) {
            return new LengthRange(Compiler.minLength(values), Compiler.maxLength(values));
        }

        private static int minLength(String[] values) {
            if (values.length == 0) {
                return 0;
            }
            int minLength = values[0].length();
            for (String value : values) {
                minLength = Math.min(minLength, value.length());
            }
            return minLength;
        }

        private static int maxLength(String[] values) {
            if (values.length == 0) {
                return 0;
            }
            int maxLength = values[0].length();
            for (String value : values) {
                maxLength = Math.max(maxLength, value.length());
            }
            return maxLength;
        }

        private static String joinRegex(String[] values) {
            StringBuilder sb = new StringBuilder("(?:");
            for (String value : values) {
                sb.append(Pattern.quote(value)).append("|");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int copyText(String formatString, int startChar) {
            boolean lastCharQuote = false;
            StringBuilder textBuilder = new StringBuilder();
            try {
                for (int i = startChar + 1; i < formatString.length(); ++i) {
                    char c = formatString.charAt(i);
                    if (c == '\'') {
                        if (lastCharQuote) {
                            textBuilder.append("'");
                            lastCharQuote = false;
                            continue;
                        }
                        lastCharQuote = true;
                        continue;
                    }
                    if (lastCharQuote) {
                        int n = i - 1;
                        return n;
                    }
                    textBuilder.append(c);
                    lastCharQuote = false;
                }
                int n = formatString.length();
                return n;
            }
            finally {
                if (textBuilder.length() == 0) {
                    this.patterns.add("'");
                } else {
                    String text = textBuilder.toString();
                    if (text.length() > 0) {
                        this.patterns.add(Pattern.quote(textBuilder.toString()));
                    }
                }
            }
        }

        private void beginPattern(char c) {
            this.patternStarted = true;
            this.charCount = 1;
            this.currentPattern = c;
        }

        private void appendChar(char c) {
            this.patterns.add(Pattern.quote(String.valueOf(c)));
            this.range = this.range.plus(1, 1);
        }

        private void endPattern() {
            if (!this.patternStarted) {
                return;
            }
            this.patternStarted = false;
            switch (this.currentPattern) {
                case 'G': {
                    this.addEraDesignator();
                    break;
                }
                case 'Y': 
                case 'y': {
                    if (this.charCount == 2) {
                        this.addYear(2);
                        break;
                    }
                    this.addYear(this.charCount);
                    break;
                }
                case 'M': {
                    if (this.charCount <= 2) {
                        this.addShortMonth();
                        break;
                    }
                    this.addLongMonth();
                    break;
                }
                case 'w': {
                    this.addWeekInYear();
                    break;
                }
                case 'W': {
                    this.addWeekInMonth();
                    break;
                }
                case 'D': {
                    this.addDayInYear();
                    break;
                }
                case 'd': {
                    this.addDayInMonth();
                    break;
                }
                case 'F': {
                    this.addDayOfWeekInMonth();
                    break;
                }
                case 'E': {
                    if (this.charCount <= 3) {
                        this.addShortDayNameInWeek();
                        break;
                    }
                    this.addLongDayNameInWeek();
                    break;
                }
                case 'u': {
                    this.addDayNumberInWeek();
                    break;
                }
                case 'a': {
                    this.addAmPmMarker();
                    break;
                }
                case 'H': {
                    this.addHourInDayBaseZero();
                    break;
                }
                case 'k': {
                    this.addHourInDayBaseOne();
                    break;
                }
                case 'K': {
                    this.add12HourBaseZero();
                    break;
                }
                case 'h': {
                    this.add12HourBaseOne();
                    break;
                }
                case 'm': {
                    this.addMinuteInHour();
                    break;
                }
                case 's': {
                    this.addSecondInMinute();
                    break;
                }
                case 'S': {
                    this.addMillisecond();
                    break;
                }
                case 'z': {
                    this.addGeneralTimeZone();
                    break;
                }
                case 'Z': {
                    this.addRFC822TimeZone();
                    break;
                }
                case 'X': {
                    this.addISO8601TimeZone();
                }
            }
        }

        private void addEraDesignator() {
            this.patterns.add(ERAS_PATTERN);
            this.range = this.range.plus(ERAS_RANGE);
        }

        private void addYear(int maxDigits) {
            this.patterns.add("(?:-?\\d{1," + maxDigits + "})");
            this.range = this.range.plus(1, maxDigits);
        }

        private void addShortMonth() {
            this.patterns.add("(?:0?[1-9]|1[0-2])");
            this.range = this.range.plus(1, 2);
        }

        private void addLongMonth() {
            this.patterns.add("(?:" + MONTHS_PATTERN + ")");
            this.range = this.range.plus(MONTH_NAME_RANGE);
        }

        private void addWeekInYear() {
            this.patterns.add("\\d{1,2}");
            this.range = this.range.plus(1, 4);
        }

        private void addWeekInMonth() {
            this.patterns.add("[0-4]");
            this.range = this.range.plus(1, 1);
        }

        private void addDayInYear() {
            this.patterns.add("\\d{1,3}");
            this.range = this.range.plus(1, 3);
        }

        private void addDayInMonth() {
            this.patterns.add("[0-3]?[0-9]");
            this.range = this.range.plus(1, 2);
        }

        private void addDayOfWeekInMonth() {
            this.patterns.add("[0-7]");
            this.range = this.range.plus(1, 1);
        }

        private void addShortDayNameInWeek() {
            this.patterns.add(SHORT_WEEKDAY_PATTERN);
            this.range = this.range.plus(SHORT_WEEKDAY_RANGE);
        }

        private void addLongDayNameInWeek() {
            this.patterns.add(LONG_WEEKDAY_PATTERN);
            this.range = this.range.plus(LONG_WEEKDAY_RANGE);
        }

        private void addDayNumberInWeek() {
            this.patterns.add("[1-7]");
            this.range = this.range.plus(1, 1);
        }

        private void addAmPmMarker() {
            this.patterns.add(AMPM_PATTERN);
            this.range = this.range.plus(AMPM_RANGE);
        }

        private void addHourInDayBaseZero() {
            this.patterns.add("(?:[0-9]|[01][0-9]|2[0-3])");
            this.range = this.range.plus(1, 2);
        }

        private void addHourInDayBaseOne() {
            this.patterns.add("(?:[1-9]|0[1-9]|1[0-9]|2[0-4])");
            this.range = this.range.plus(1, 2);
        }

        private void add12HourBaseZero() {
            this.patterns.add("(?:0?[0-9]|1[01])");
            this.range = this.range.plus(1, 2);
        }

        private void add12HourBaseOne() {
            this.patterns.add("(?:[1-9]|0[1-9]|1[012])");
            this.range = this.range.plus(1, 2);
        }

        private void addMinuteInHour() {
            this.patterns.add("(?:[0-9]|[0-5][0-9])");
            this.range = this.range.plus(1, 2);
        }

        private void addSecondInMinute() {
            this.addMinuteInHour();
            this.range = this.range.plus(1, 2);
        }

        private void addMillisecond() {
            this.patterns.add("\\d{1,3}");
            this.range = this.range.plus(1, 3);
        }

        private void addGeneralTimeZone() {
            StringBuilder sb = new StringBuilder();
            sb.append("(?:");
            sb.append(this.getGMTOffsetTimeZone());
            sb.append("|");
            sb.append(this.getNamedTimeZone());
            sb.append(")");
            this.patterns.add(sb.toString());
            this.range = this.range.plus(ZONE_NAME_RANGE);
        }

        private String getGMTOffsetTimeZone() {
            return "(?:GMT[-+]\\d{1,2}:\\d{2})";
        }

        private String getNamedTimeZone() {
            return ZONE_NAME_PATTERN;
        }

        private void addRFC822TimeZone() {
            this.patterns.add("(?:[-+]\\d{4})");
            this.range = this.range.plus(5, 5);
        }

        private void addISO8601TimeZone() {
            this.patterns.add("(?:Z|(?:[-+](?:\\d{2}|\\d{4}|\\d{2}\\:\\d{2})))");
            this.range = this.range.plus(1, 6);
        }

        static {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(Locale.US);
            String[] ampm = dateFormatSymbols.getAmPmStrings();
            AMPM_PATTERN = Compiler.joinRegex(ampm);
            AMPM_RANGE = Compiler.lengthRange(ampm);
            String[] eras = dateFormatSymbols.getEras();
            ERAS_PATTERN = Compiler.joinRegex(eras);
            ERAS_RANGE = Compiler.lengthRange(eras);
            ArrayList<String> monthNames = new ArrayList<String>();
            monthNames.addAll(Arrays.asList(dateFormatSymbols.getMonths()));
            monthNames.addAll(Arrays.asList(dateFormatSymbols.getShortMonths()));
            String[] monthNameArray = monthNames.toArray(new String[0]);
            MONTHS_PATTERN = Compiler.joinRegex(monthNameArray);
            MONTH_NAME_RANGE = Compiler.lengthRange(monthNameArray);
            String[] longWeekdays = dateFormatSymbols.getWeekdays();
            LONG_WEEKDAY_PATTERN = Compiler.joinRegex(longWeekdays);
            LONG_WEEKDAY_RANGE = Compiler.lengthRange(longWeekdays);
            String[] shortWeekdays = dateFormatSymbols.getShortWeekdays();
            SHORT_WEEKDAY_PATTERN = Compiler.joinRegex(shortWeekdays);
            SHORT_WEEKDAY_RANGE = Compiler.lengthRange(shortWeekdays);
            int maxTimeZoneLength = 0;
            String[][] zoneStrings = dateFormatSymbols.getZoneStrings();
            StringBuilder zoneNamePatternBuilder = new StringBuilder();
            String[][] stringArray = zoneStrings;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] zoneNames;
                for (String zoneName : zoneNames = stringArray[i]) {
                    if (zoneName == null || zoneName.isEmpty()) continue;
                    zoneNamePatternBuilder.append(Pattern.quote(zoneName)).append("|");
                    maxTimeZoneLength = Math.max(maxTimeZoneLength, zoneName.length());
                }
            }
            zoneNamePatternBuilder.deleteCharAt(zoneNamePatternBuilder.length() - 1);
            ZONE_NAME_PATTERN = zoneNamePatternBuilder.toString();
            ZONE_NAME_RANGE = new LengthRange(1, maxTimeZoneLength);
        }

        private static class LengthRange {
            private final int min;
            private final int max;

            public LengthRange(int min, int max) {
                this.min = min;
                this.max = max;
            }

            public int getMinLength() {
                return this.min;
            }

            public int getMaxLength() {
                return this.max;
            }

            public LengthRange plus(LengthRange other) {
                return new LengthRange(this.getMinLength() + other.getMinLength(), this.getMaxLength() + other.getMaxLength());
            }

            public LengthRange plus(int min, int max) {
                return new LengthRange(this.getMinLength() + min, this.getMaxLength() + max);
            }
        }
    }
}

