/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.kms.v1.KeyName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeyRingName
extends KeyName {
    private static final PathTemplate PROJECT_LOCATION_KEY_RING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/keyRings/{key_ring}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String keyRing;

    @Deprecated
    protected KeyRingName() {
        this.project = null;
        this.location = null;
        this.keyRing = null;
    }

    private KeyRingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.keyRing = (String)Preconditions.checkNotNull((Object)builder.getKeyRing());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyRing() {
        return this.keyRing;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeyRingName of(String project, String location, String keyRing) {
        return KeyRingName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).build();
    }

    public static String format(String project, String location, String keyRing) {
        return KeyRingName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).build().toString();
    }

    public static KeyRingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_KEY_RING.validatedMatch(formattedString, "KeyRingName.parse: formattedString not in valid format");
        return KeyRingName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("key_ring"));
    }

    public static List<KeyRingName> parseList(List<String> formattedStrings) {
        ArrayList<KeyRingName> list = new ArrayList<KeyRingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeyRingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeyRingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeyRingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_KEY_RING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeyRingName keyRingName = this;
            synchronized (keyRingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.keyRing != null) {
                        fieldMapBuilder.put((Object)"key_ring", (Object)this.keyRing);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_KEY_RING.instantiate(new String[]{"project", this.project, "location", this.location, "key_ring", this.keyRing});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            KeyRingName that = (KeyRingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.keyRing, that.keyRing);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.keyRing);
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyRing;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyRing() {
            return this.keyRing;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyRing(String keyRing) {
            this.keyRing = keyRing;
            return this;
        }

        private Builder(KeyRingName keyRingName) {
            this.project = keyRingName.project;
            this.location = keyRingName.location;
            this.keyRing = keyRingName.keyRing;
        }

        public KeyRingName build() {
            return new KeyRingName(this);
        }
    }
}

