/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.util;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.SortedEntityIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImmutableSingleTypeEntityIdBitSet
implements SortedEntityIdSet {
    private final int singleTypeId;
    private final int size;
    private final long min;
    private final long max;
    private final BitSet data;

    @Deprecated
    public ImmutableSingleTypeEntityIdBitSet(int singleTypeId, long[] source) {
        this(singleTypeId, source, source.length);
    }

    @Deprecated
    public ImmutableSingleTypeEntityIdBitSet(int singleTypeId, long[] source, int length) {
        this(singleTypeId, source[0], source[length - 1], source, length);
    }

    public ImmutableSingleTypeEntityIdBitSet(int singleTypeId, long min, long max, long[] source, int length) {
        if (length > source.length) {
            throw new IllegalArgumentException();
        }
        this.singleTypeId = singleTypeId;
        this.min = min;
        this.max = max;
        long bitsCount = max - min + 1L;
        if (min < 0L || bitsCount >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.data = new BitSet((int)bitsCount);
        for (int i = 0; i < length; ++i) {
            this.data.set((int)(source[i] - min));
        }
        this.size = this.data.cardinality();
    }

    public ImmutableSingleTypeEntityIdBitSet(int singleTypeId, long min, long max, LongIterator source) {
        this.singleTypeId = singleTypeId;
        this.min = min;
        this.max = max;
        long bitsCount = max - min + 1L;
        if (min < 0L || bitsCount >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.data = new BitSet((int)bitsCount);
        while (source.hasNext()) {
            this.data.set((int)((Long)source.next() - min));
        }
        this.size = this.data.cardinality();
    }

    public EntityIdSet add(@Nullable EntityId id) {
        throw new UnsupportedOperationException();
    }

    public EntityIdSet add(int typeId, long localId) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(@Nullable EntityId id) {
        return id != null && this.contains(id.getTypeId(), id.getLocalId());
    }

    public boolean contains(int typeId, long localId) {
        return typeId == this.singleTypeId && localId >= this.min && localId <= this.max && this.data.get((int)(localId - this.min));
    }

    public boolean remove(@Nullable EntityId id) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(int typeId, long localId) {
        throw new UnsupportedOperationException();
    }

    public int count() {
        return this.size;
    }

    @NotNull
    public Iterator<EntityId> iterator() {
        return new IdIterator();
    }

    public int indexOf(@NotNull EntityId entityId) {
        long id = entityId.getLocalId();
        if (!this.contains(entityId.getTypeId(), id)) {
            return -1;
        }
        int nextBitIndex = this.data.nextSetBit(0);
        int result = 0;
        if (nextBitIndex != -1) {
            id -= this.min;
            while ((long)nextBitIndex < id) {
                ++result;
                if ((nextBitIndex = this.data.nextSetBit(nextBitIndex + 1)) != -1) continue;
                break;
            }
        }
        return result;
    }

    public EntityId getFirst() {
        return new PersistentEntityId(this.singleTypeId, this.min);
    }

    public EntityId getLast() {
        return new PersistentEntityId(this.singleTypeId, this.max);
    }

    public Iterator<EntityId> reverseIterator() {
        return new ReverseIdIterator();
    }

    @NotNull
    public LongSet getTypeSetSnapshot(int typeId) {
        if (typeId == this.singleTypeId) {
            PackedLongHashSet result = new PackedLongHashSet();
            int next = this.data.nextSetBit(0);
            while (next != -1) {
                result.add((long)next + this.min);
                next = this.data.nextSetBit(next + 1);
            }
            return result;
        }
        return LongSet.EMPTY;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    class ReverseIdIterator
    implements Iterator<EntityId> {
        int nextBitIndex;

        ReverseIdIterator() {
            this.nextBitIndex = ImmutableSingleTypeEntityIdBitSet.this.data.previousSetBit((int)(ImmutableSingleTypeEntityIdBitSet.this.max - ImmutableSingleTypeEntityIdBitSet.this.min));
        }

        @Override
        public boolean hasNext() {
            return this.nextBitIndex != -1;
        }

        @Override
        public EntityId next() {
            if (this.nextBitIndex != -1) {
                int bitIndex = this.nextBitIndex;
                this.nextBitIndex = ImmutableSingleTypeEntityIdBitSet.this.data.previousSetBit(this.nextBitIndex - 1);
                return new PersistentEntityId(ImmutableSingleTypeEntityIdBitSet.this.singleTypeId, (long)bitIndex + ImmutableSingleTypeEntityIdBitSet.this.min);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class IdIterator
    implements Iterator<EntityId> {
        int nextBitIndex;

        IdIterator() {
            this.nextBitIndex = ImmutableSingleTypeEntityIdBitSet.this.data.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.nextBitIndex != -1;
        }

        @Override
        public EntityId next() {
            if (this.nextBitIndex != -1) {
                int bitIndex = this.nextBitIndex;
                this.nextBitIndex = ImmutableSingleTypeEntityIdBitSet.this.data.nextSetBit(this.nextBitIndex + 1);
                return new PersistentEntityId(ImmutableSingleTypeEntityIdBitSet.this.singleTypeId, (long)bitIndex + ImmutableSingleTypeEntityIdBitSet.this.min);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

