/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupImportEntity;
import org.apache.nifi.web.api.entity.ProcessGroupReplaceRequestEntity;

public class PGReplace
extends AbstractNiFiCommand<VoidResult> {
    public PGReplace() {
        super("pg-replace", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Replaces the content of a process group with the content from the specified versioned flow snapshot.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        String inputFile = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        String contents = this.getInputSourceContent(inputFile);
        ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
        RegisteredFlowSnapshot deserializedSnapshot = (RegisteredFlowSnapshot)objectMapper.readValue(contents, RegisteredFlowSnapshot.class);
        if (deserializedSnapshot == null) {
            throw new IOException("Unable to deserialize flow version from " + inputFile);
        }
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        ProcessGroupEntity existingProcessGroup = pgClient.getProcessGroup(pgId);
        ProcessGroupImportEntity importEntity = new ProcessGroupImportEntity();
        importEntity.setVersionedFlowSnapshot(deserializedSnapshot);
        importEntity.setProcessGroupRevision(existingProcessGroup.getRevision());
        ProcessGroupReplaceRequestEntity createdReplaceRequestEntity = pgClient.replaceProcessGroup(pgId, importEntity);
        String requestId = createdReplaceRequestEntity.getRequest().getRequestId();
        try {
            boolean completed = false;
            for (int i = 0; i < 30; ++i) {
                ProcessGroupReplaceRequestEntity replaceRequest = pgClient.getProcessGroupReplaceRequest(pgId, requestId);
                if (replaceRequest != null && replaceRequest.getRequest().isComplete()) {
                    completed = true;
                    break;
                }
                try {
                    if (this.getContext().isInteractive()) {
                        this.println("Waiting for replacement request to complete...");
                    }
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!completed) {
                throw new NiFiClientException("Unable to replace process group, cancelling request");
            }
        }
        finally {
            pgClient.deleteProcessGroupReplaceRequest(pgId, requestId);
        }
        return VoidResult.getInstance();
    }
}

