/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.persistence.TemplateSerializer;
import org.apache.nifi.toolkit.cli.api.WritableResult;
import org.apache.nifi.web.api.dto.TemplateDTO;

public class TemplateResult
implements WritableResult<TemplateDTO> {
    private final TemplateDTO templateDTO;
    private final String exportFileName;

    public TemplateResult(TemplateDTO templateDTO, String exportFileName) {
        this.templateDTO = templateDTO;
        this.exportFileName = exportFileName;
        Validate.notNull((Object)this.templateDTO);
    }

    @Override
    public TemplateDTO getResult() {
        return this.templateDTO;
    }

    @Override
    public void write(PrintStream output) throws IOException {
        byte[] serializedTemplate = TemplateSerializer.serialize((TemplateDTO)this.templateDTO);
        if (this.exportFileName != null) {
            try (FileOutputStream resultOut = new FileOutputStream(this.exportFileName);){
                ((OutputStream)resultOut).write(serializedTemplate);
            }
        } else {
            output.write(serializedTemplate);
        }
    }
}

