/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedureThrows;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHashMap<K, V>
extends AbstractMap<K, V> {
    protected int _size;

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void clear() {
        this.init(0);
    }

    @Override
    public V get(Object key) {
        Map.Entry<K, V> e = this.getEntry(key);
        return e == null ? null : (V)e.getValue();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new Values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public boolean forEachKey(ObjectProcedure<K> procedure) {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (procedure.execute(entry.getKey())) continue;
            return false;
        }
        return true;
    }

    public boolean forEachValue(ObjectProcedure<V> procedure) {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (procedure.execute(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(ObjectProcedure<Map.Entry<K, V>> procedure) {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (procedure.execute(entry)) continue;
            return false;
        }
        return true;
    }

    public <E extends Throwable> boolean forEachEntry(ObjectProcedureThrows<Map.Entry<K, V>, E> procedure) throws E {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (procedure.execute(entry)) continue;
            return false;
        }
        return true;
    }

    protected abstract Map.Entry<K, V> getEntry(Object var1);

    protected abstract void init(int var1);

    protected abstract HashMapIterator hashIterator();

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new HashIteratorDecorator<V>(){

                @Override
                public V next() {
                    return this.decorated.nextEntry().getValue();
                }
            };
        }

        @Override
        public int size() {
            return AbstractHashMap.this._size;
        }

        @Override
        public boolean contains(Object o) {
            return AbstractHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            AbstractHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new HashIteratorDecorator<K>(){

                @Override
                public K next() {
                    return this.decorated.nextEntry().getKey();
                }
            };
        }

        @Override
        public int size() {
            return AbstractHashMap.this._size;
        }

        @Override
        public boolean contains(Object o) {
            return AbstractHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractHashMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new HashIteratorDecorator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.decorated.nextEntry();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry rightEntry = (Map.Entry)o;
            Map.Entry leftEntry = AbstractHashMap.this.getEntry(rightEntry.getKey());
            return leftEntry != null && leftEntry.getValue().equals(rightEntry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return AbstractHashMap.this.remove(e.getKey()) != null;
        }

        @Override
        public int size() {
            return AbstractHashMap.this._size;
        }

        @Override
        public void clear() {
            AbstractHashMap.this.clear();
        }
    }

    private abstract class HashIteratorDecorator<T>
    implements Iterator<T> {
        protected final HashMapIterator decorated;

        protected HashIteratorDecorator() {
            this.decorated = AbstractHashMap.this.hashIterator();
        }

        @Override
        public boolean hasNext() {
            return this.decorated.hasNext();
        }

        @Override
        public void remove() {
            this.decorated.remove();
        }
    }

    protected abstract class HashMapIterator {
        protected HashMapIterator() {
        }

        protected abstract Map.Entry<K, V> nextEntry();

        protected abstract boolean hasNext();

        protected abstract void remove();
    }
}

