/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import jetbrains.exodus.core.execution.LatchJob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatingJobProcessor<T extends JobProcessorAdapter>
extends JobProcessorAdapter {
    protected final T delegate;

    public DelegatingJobProcessor(@NotNull T delegate) {
        this.delegate = delegate;
    }

    public T getDelegate() {
        return this.delegate;
    }

    @Override
    public void start() {
        if (!this.started.getAndSet(true)) {
            this.delegate.start();
            this.finished.set(false);
            Job startJob = new Job(){

                @Override
                protected void execute() {
                    DelegatingJobProcessor.this.processorStarted();
                }
            };
            startJob.setProcessor(this);
            ((JobProcessorAdapter)this.delegate).queue(startJob, Priority.highest);
        }
    }

    @Override
    public void finish() {
        if (this.started.get() && !this.finished.getAndSet(true)) {
            ((JobProcessorAdapter)this.delegate).waitForLatchJob(new LatchJob(){

                @Override
                protected void execute() {
                    try {
                        DelegatingJobProcessor.this.processorFinished();
                    }
                    catch (Throwable t) {
                        JobProcessorExceptionHandler exceptionHandler = DelegatingJobProcessor.this.getExceptionHandler();
                        if (exceptionHandler != null) {
                            exceptionHandler.handle(DelegatingJobProcessor.this, this, t);
                        }
                    }
                    finally {
                        this.release();
                    }
                }
            }, 100L);
            this.setExceptionHandler(null);
            this.started.set(false);
        }
    }

    @Override
    public int pendingJobs() {
        return this.delegate.pendingJobs();
    }

    @Override
    public void waitForJobs(long spinTimeout) {
        ((JobProcessorAdapter)this.delegate).waitForJobs(spinTimeout);
    }

    @Override
    public void waitForTimedJobs(long spinTimeout) {
        ((JobProcessorAdapter)this.delegate).waitForTimedJobs(spinTimeout);
    }

    @Override
    @Nullable
    public Job getCurrentJob() {
        return this.delegate.getCurrentJob();
    }

    @Override
    public long getCurrentJobStartedAt() {
        return this.delegate.getCurrentJobStartedAt();
    }

    @Override
    @NotNull
    public Iterable<Job> getPendingJobs() {
        return this.delegate.getPendingJobs();
    }

    @Override
    public int pendingTimedJobs() {
        return this.delegate.pendingTimedJobs();
    }

    public String toString() {
        return "delegating -> " + this.delegate;
    }

    @Override
    protected boolean queueLowest(@NotNull Job job) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean queueLowestTimed(@NotNull Job job) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean push(Job job, Priority priority) {
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        return ((JobProcessorAdapter)this.delegate).push(job, priority);
    }

    @Override
    protected Job pushAt(Job job, long millis) {
        if (this.isFinished()) {
            return null;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        return ((JobProcessorAdapter)this.delegate).pushAt(job, millis);
    }
}

