/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ReverseTableMapItem;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntHashSet;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.util.Map;

public class TableNameRegistryFileStore
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TableNameRegistryFileStore.class);
    private static final int OPERATION_ADD = 0;
    private static final int OPERATION_REMOVE = -1;
    private static final long TABLE_NAME_ENTRY_RESERVED_LONGS = 8L;
    private static final int TABLE_TYPE_NON_WAL = 0;
    private static final int TABLE_TYPE_WAL = 1;
    private final CairoConfiguration configuration;
    private final StringSink nameSink = new StringSink();
    private final IntHashSet tableIds = new IntHashSet();
    private final MemoryMARW tableNameMemory = Vm.getCMARWInstance();
    private final MemoryCMR tableNameRoMemory = Vm.getCMRInstance();
    private int lockFd = -1;

    public TableNameRegistryFileStore(CairoConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized void appendEntry(TableToken tableToken) {
        this.writeEntry(tableToken, 0);
    }

    @Override
    public void close() {
        if (this.lockFd != -1) {
            this.configuration.getFilesFacade().close(this.lockFd);
            this.lockFd = -1;
        }
        this.tableNameMemory.close(false);
    }

    public boolean isLocked() {
        return this.lockFd != -1;
    }

    public boolean lock() {
        Path path;
        if (this.lockFd != -1) {
            throw CairoException.critical(0).put("table registry already locked");
        }
        FilesFacade ff = this.configuration.getFilesFacade();
        if (ff.exists(path = Path.getThreadLocal(this.configuration.getRoot()).concat("tables.d").put(".lock").$())) {
            ff.touch(path);
        }
        this.lockFd = TableUtils.lock(ff, path);
        return this.lockFd != -1;
    }

    public synchronized void logDropTable(TableToken tableToken) {
        this.writeEntry(tableToken, -1);
    }

    public synchronized void resetMemory() {
        if (!this.isLocked() && !this.lock()) {
            throw CairoException.critical(0).put("table registry is not locked");
        }
        this.tableNameMemory.close();
        Path path = Path.getThreadLocal(this.configuration.getRoot()).concat("tables.d").put(".0").$();
        this.configuration.getFilesFacade().remove(path);
        this.tableNameMemory.smallFile(this.configuration.getFilesFacade(), path, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactTableNameFile(Map<CharSequence, TableToken> nameTableTokenMap, int lastFileVersion, FilesFacade ff, Path path, long currentOffset) {
        int pathRootLen = path.length();
        path.concat("tables.d").put(".tmp").$();
        try {
            this.tableNameMemory.close(false);
            this.tableNameMemory.smallFile(ff, path, 0);
            this.tableNameMemory.putLong(0L);
            for (TableToken token : nameTableTokenMap.values()) {
                this.writeEntry(token, 0);
            }
            this.tableNameMemory.sync(false);
            long newAppendOffset = this.tableNameMemory.getAppendOffset();
            this.tableNameMemory.close();
            Path path2 = Path.getThreadLocal2(this.configuration.getRoot()).concat("tables.d").put('.').put(lastFileVersion + 1).$();
            if (ff.rename(path, path2) == 0) {
                LOG.info().$("compacted tables file [path=").$(path2).$(']').$();
                currentOffset = newAppendOffset;
                path.trimTo(pathRootLen).concat("tables.d").put('.').put(++lastFileVersion - 1).$();
                ff.remove(path);
            } else {
                LOG.error().$("could not rename tables file, tables file will not be compacted [from=").$(path).$(", to=").$(path2).$(']').$();
            }
        }
        finally {
            path.trimTo(pathRootLen).concat("tables.d").put('.').put(lastFileVersion).$();
            this.tableNameMemory.smallFile(ff, path, 0);
            this.tableNameMemory.jumpTo(currentOffset);
        }
        this.tableNameMemory.jumpTo(currentOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findLastTablesFileVersion(FilesFacade ff, Path path) {
        long findPtr = ff.findFirst(path.$());
        if (findPtr == 0L) {
            throw CairoException.critical(0).put("database root directory does not exist at ").put(path);
        }
        try {
            int lastVersion = 0;
            do {
                long pUtf8NameZ = ff.findName(findPtr);
                if (ff.findType(findPtr) != 8) continue;
                this.nameSink.clear();
                Chars.utf8DecodeZ(pUtf8NameZ, this.nameSink);
                if (!Chars.startsWith((CharSequence)this.nameSink, "tables.d") || this.nameSink.length() <= "tables.d".length() + 1) continue;
                try {
                    int version = Numbers.parseInt(this.nameSink, "tables.d".length() + 1, this.nameSink.length());
                    if (version <= lastVersion) continue;
                    lastVersion = version;
                }
                catch (NumericException numericException) {
                    // empty catch block
                }
            } while (ff.findNext(findPtr) > 0);
            int n = lastVersion;
            return n;
        }
        finally {
            ff.findClose(findPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTableId(Path path, CharSequence dirName, FilesFacade ff) {
        path.of(this.configuration.getRoot()).concat(dirName).concat("_meta").$();
        int fd = ff.openRO(path);
        if (fd < 1) {
            return 0;
        }
        try {
            int tableId = ff.readNonNegativeInt(fd, 16L);
            if (tableId < 0) {
                LOG.error().$("cannot read table id from metadata file [path=").$(path).I$();
                int n = 0;
                return n;
            }
            byte isWal = (byte)(ff.readNonNegativeInt(fd, 40L) & 0xFF);
            int n = isWal == 0 ? tableId : -tableId;
            return n;
        }
        finally {
            ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTableName(Path path, CharSequence dirName, FilesFacade ff) {
        path.of(this.configuration.getRoot()).concat(dirName).concat("_name").$();
        int fd = ff.openRO(path);
        if (fd < 1) {
            return null;
        }
        try {
            long fileLen = ff.length(fd);
            if (fileLen > 4L) {
                int charLen = ff.readNonNegativeInt(fd, 0L);
                if ((long)charLen * 2L + 4L != fileLen - 1L) {
                    LOG.error().$("invalid table name file [path=").$(path).$(", headerLen=").$(charLen).$(", fileLne=").$(fileLen).I$();
                    String string = null;
                    return string;
                }
                this.tableNameRoMemory.of(ff, path, fileLen, fileLen, 0);
                String value = Chars.toString(this.tableNameRoMemory.getStr(0L));
                this.tableNameRoMemory.close();
                String string = value;
                return string;
            }
            LOG.error().$("invalid table name file [path=").$(path).$(", fileLne=").$(fileLen).I$();
            String string = null;
            return string;
        }
        finally {
            ff.close(fd);
        }
    }

    private void reloadFromRootDirectory(ConcurrentHashMap<TableToken> nameTableTokenMap, ConcurrentHashMap<ReverseTableMapItem> reverseTableNameTokenMap) {
        Path path = Path.getThreadLocal(this.configuration.getRoot());
        int plimit = path.length();
        FilesFacade ff = this.configuration.getFilesFacade();
        long findPtr = ff.findFirst(path.$());
        StringSink sink = Misc.getThreadLocalBuilder();
        do {
            String tableName;
            boolean isWal;
            int tableId;
            if (!ff.isDirOrSoftLinkDirNoDots(path, plimit, ff.findName(findPtr), ff.findType(findPtr), sink) || reverseTableNameTokenMap.containsKey(sink) || TableUtils.exists(ff, path, this.configuration.getRoot(), sink) != 0) continue;
            String dirName = sink.toString();
            try {
                tableId = this.readTableId(path, dirName, ff);
                isWal = tableId < 0;
                tableId = Math.abs(tableId);
                tableName = this.readTableName(path, dirName, ff);
            }
            catch (CairoException e) {
                if (e.errnoReadPathDoesNotExist()) continue;
                throw e;
            }
            if (tableName == null) {
                if (isWal) {
                    LOG.error().$("could not read table name, table will not be available [dirName=").utf8(dirName).I$();
                    continue;
                }
                tableName = Chars.toString(TableUtils.getTableNameFromDirName(dirName));
            }
            if ((long)tableId <= -1L) continue;
            if (this.tableIds.contains(tableId)) {
                LOG.critical().$("duplicate table id found, table will not be available [dirName=").utf8(dirName).$(", id=").$(tableId).I$();
                continue;
            }
            if (nameTableTokenMap.containsKey(tableName)) {
                LOG.critical().$("duplicate table name found, table will not be available [dirName=").utf8(dirName).$(", name=").utf8(tableName).$(", existingTableDir=").utf8(nameTableTokenMap.get(tableName).getDirName()).I$();
                continue;
            }
            TableToken token = new TableToken(tableName, dirName, tableId, isWal);
            nameTableTokenMap.put(tableName, token);
            reverseTableNameTokenMap.put(dirName, ReverseTableMapItem.of(token));
        } while (ff.findNext(findPtr) > 0);
        ff.findClose(findPtr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reloadFromTablesFile(ConcurrentHashMap<TableToken> nameTableTokenMap, ConcurrentHashMap<ReverseTableMapItem> reverseTableNameTokenMap) {
        int lastFileVersion;
        FilesFacade ff = this.configuration.getFilesFacade();
        Path path = Path.getThreadLocal(this.configuration.getRoot());
        path.of(this.configuration.getRoot());
        int pathRootLen = path.length();
        MemoryMR memory = this.isLocked() ? this.tableNameMemory : this.tableNameRoMemory;
        while (true) {
            lastFileVersion = this.findLastTablesFileVersion(ff, path.trimTo(pathRootLen).$());
            path.trimTo(pathRootLen).concat("tables.d").put('.').put(lastFileVersion).$();
            try {
                memory.smallFile(ff, path, 0);
                LOG.info().$("reloading tables file [path=").utf8(path).I$();
                if (memory.size() < 16L) continue;
            }
            catch (CairoException e) {
                if (this.isLocked() || !e.errnoReadPathDoesNotExist()) throw e;
                if (lastFileVersion == 0) return;
                continue;
            }
            break;
        }
        long mapMem = memory.getLong(0L);
        long currentOffset = 8L;
        memory.extend(mapMem);
        int deletedRecordsFound = 0;
        while (currentOffset < mapMem) {
            int operation = memory.getInt(currentOffset);
            String tableName = Chars.toString(memory.getStr(currentOffset += 4L));
            String dirName = Chars.toString(memory.getStr(currentOffset += (long)Vm.getStorageLength(tableName)));
            int tableId = memory.getInt(currentOffset += (long)Vm.getStorageLength(dirName));
            int tableType = memory.getInt(currentOffset += 4L);
            currentOffset += 4L;
            TableToken token = new TableToken(tableName, dirName, tableId, tableType == 1);
            if (operation == -1) {
                TableToken tableToken = nameTableTokenMap.remove(tableName);
                if (tableToken == null) continue;
                reverseTableNameTokenMap.put(dirName, ReverseTableMapItem.ofDropped(tableToken));
                ++deletedRecordsFound;
                continue;
            }
            if (this.tableIds.contains(tableId)) {
                LOG.critical().$("duplicate table id found, table will not be accessible [dirName=").$(dirName).$(", id=").$(tableId).$(']').$();
                continue;
            }
            nameTableTokenMap.put(tableName, token);
            if (!Chars.startsWith((CharSequence)token.getDirName(), token.getTableName())) {
                LOG.advisory().$("renamed WAL table system name [table=").utf8(tableName).$(", dirName=").utf8(dirName).$();
            }
            reverseTableNameTokenMap.put(token.getDirName(), ReverseTableMapItem.of(token));
            currentOffset += 64L;
        }
        if (this.isLocked()) {
            for (TableToken token : nameTableTokenMap.values()) {
                if (TableUtils.exists(ff, path, this.configuration.getRoot(), token.getDirName()) == 0) continue;
                LOG.error().$("table directory directly removed from File System, table will not be available [path=").utf8(path).$(", dirName=").utf8(token.getDirName()).$(", table=").utf8(token.getTableName()).I$();
                nameTableTokenMap.remove(token.getTableName());
                reverseTableNameTokenMap.remove(token.getDirName());
                ++deletedRecordsFound;
            }
            if (deletedRecordsFound > 0) {
                LOG.info().$("compacting tables file [path=").$(path).$(']').$();
                path.trimTo(pathRootLen);
                this.compactTableNameFile(nameTableTokenMap, lastFileVersion, ff, path, currentOffset);
                return;
            } else {
                this.tableNameMemory.jumpTo(currentOffset);
            }
            return;
        } else {
            this.tableNameRoMemory.close();
        }
    }

    private void writeEntry(TableToken tableToken, int operation) {
        if (!this.isLocked()) {
            throw CairoException.critical(0).put("table registry is not locked");
        }
        this.tableNameMemory.putInt(operation);
        this.tableNameMemory.putStr(tableToken.getTableName());
        this.tableNameMemory.putStr(tableToken.getDirName());
        this.tableNameMemory.putInt(tableToken.getTableId());
        this.tableNameMemory.putInt(tableToken.isWal() ? 1 : 0);
        if (operation != -1) {
            int i = 0;
            while ((long)i < 8L) {
                this.tableNameMemory.putLong(0L);
                ++i;
            }
        }
        this.tableNameMemory.putLong(0L, this.tableNameMemory.getAppendOffset());
    }

    void reload(ConcurrentHashMap<TableToken> nameTableTokenMap, ConcurrentHashMap<ReverseTableMapItem> reverseTableNameTokenMap) {
        this.tableIds.clear();
        this.reloadFromTablesFile(nameTableTokenMap, reverseTableNameTokenMap);
        this.reloadFromRootDirectory(nameTableTokenMap, reverseTableNameTokenMap);
    }
}

